/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;

public final class LightPersistenceXmlDescriptor
implements PersistenceUnitDescriptor {
    private static final Logger log = Logger.getLogger(LightPersistenceXmlDescriptor.class);
    private final String name;
    private final String providerClassName;
    private final boolean useQuotedIdentifiers;
    private final PersistenceUnitTransactionType transactionType;
    private final ValidationMode validationMode;
    private final SharedCacheMode sharedCachemode;
    private final List<String> managedClassNames;
    private final Properties properties;

    public LightPersistenceXmlDescriptor(PersistenceUnitDescriptor toClone) {
        this.name = toClone.getName();
        this.providerClassName = toClone.getProviderClassName();
        this.useQuotedIdentifiers = toClone.isUseQuotedIdentifiers();
        this.transactionType = toClone.getTransactionType();
        this.validationMode = toClone.getValidationMode();
        this.sharedCachemode = toClone.getSharedCacheMode();
        this.managedClassNames = Collections.unmodifiableList(toClone.getManagedClassNames());
        this.properties = toClone.getProperties();
        LightPersistenceXmlDescriptor.verifyIgnoredFields(toClone);
    }

    private static void verifyIgnoredFields(PersistenceUnitDescriptor toClone) {
        if (toClone.getNonJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getNonJtaDataSource : not supported yet");
        }
        if (toClone.getMappingFileNames() != null && !toClone.getMappingFileNames().isEmpty()) {
            throw new UnsupportedOperationException("Value found for #getMappingFileNames : not supported yet");
        }
        if (toClone.getJarFileUrls() != null && !toClone.getJarFileUrls().isEmpty()) {
            throw new UnsupportedOperationException("Value found for #getJarFileUrls : not supported yet");
        }
        if (toClone.getJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getJtaDataSource : not supported yet");
        }
        if (toClone.getNonJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getNonJtaDataSource : not supported");
        }
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public boolean isExcludeUnlistedClasses() {
        return true;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCachemode;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public List<String> getMappingFileNames() {
        return Collections.emptyList();
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public Object getNonJtaDataSource() {
        return null;
    }

    public Object getJtaDataSource() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public ClassLoader getTempClassLoader() {
        return null;
    }

    public void pushClassTransformer(EnhancementContext enhancementContext) {
    }

    public String toString() {
        return "PersistenceUnitDescriptor{name='" + this.name + '\'' + ", providerClassName='" + this.providerClassName + '\'' + ", useQuotedIdentifiers=" + this.useQuotedIdentifiers + ", transactionType=" + this.transactionType + ", validationMode=" + this.validationMode + ", sharedCachemode=" + this.sharedCachemode + ", managedClassNames=" + this.managedClassNames + ", properties=" + this.properties + '}';
    }
}

