/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.proxies;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.pojo.ProxyFactoryHelper;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.jboss.logging.Logger;

public final class ProxyDefinitions {
    private final Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap;
    private static final Logger LOGGER = Logger.getLogger((String)ProxyDefinitions.class.getName());

    private ProxyDefinitions(Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap) {
        this.proxyDefinitionMap = proxyDefinitionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProxyDefinitions createFromMetadata(Metadata storeableMetadata) {
        if (!ProxyDefinitions.needAnyProxyDefinitions(storeableMetadata)) return new ProxyDefinitions(Collections.emptyMap());
        HashMap proxyDefinitionMap = new HashMap();
        BytecodeProviderImpl bytecodeProvider = new BytecodeProviderImpl();
        try {
            ByteBuddyProxyHelper byteBuddyProxyHelper = bytecodeProvider.getByteBuddyProxyHelper();
            for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
                if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
                Class mappedClass = persistentClass.getMappedClass();
                Class proxyClassDefinition = ProxyDefinitions.generateProxyClass(persistentClass, byteBuddyProxyHelper);
                if (proxyClassDefinition == null) continue;
                boolean overridesEquals = ReflectHelper.overridesEquals((Class)mappedClass);
                try {
                    proxyDefinitionMap.put(mappedClass, new ProxyClassDetailsHolder(overridesEquals, proxyClassDefinition.getConstructor(new Class[0])));
                }
                catch (NoSuchMethodException e) {
                    throw new HibernateException("Failed to generate Enhanced Proxy: default constructor is missing for entity '" + mappedClass.getName() + "'. Please add a default constructor explicitly.");
                    return new ProxyDefinitions(proxyDefinitionMap);
                }
            }
        }
        finally {
            bytecodeProvider.resetCaches();
        }
    }

    private static boolean needAnyProxyDefinitions(Metadata storeableMetadata) {
        for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
            if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsProxyGeneration(PersistentClass persistentClass) {
        return persistentClass.isLazy() && persistentClass.getMappedClass() != null;
    }

    private static Class generateProxyClass(PersistentClass persistentClass, ByteBuddyProxyHelper byteBuddyProxyHelper) {
        String entityName = persistentClass.getEntityName();
        Class mappedClass = persistentClass.getMappedClass();
        if ((mappedClass.getModifiers() & 0x10) == 16) {
            LOGGER.warn((Object)("Could not generate an enhanced proxy for entity '" + entityName + "' (class='" + mappedClass.getCanonicalName() + "') as it's final. Your application might perform better if we're allowed to extend it."));
            return null;
        }
        Set proxyInterfaces = ProxyFactoryHelper.extractProxyInterfaces((PersistentClass)persistentClass, (String)entityName);
        Class proxyDef = byteBuddyProxyHelper.buildProxy(mappedClass, ProxyDefinitions.toArray(proxyInterfaces));
        return proxyDef;
    }

    private static Class[] toArray(Set<Class> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public ProxyClassDetailsHolder getProxyForClass(Class persistentClass) {
        return this.proxyDefinitionMap.get(persistentClass);
    }

    public static class ProxyClassDetailsHolder {
        private final boolean overridesEquals;
        private final Constructor constructor;

        private ProxyClassDetailsHolder(boolean overridesEquals, Constructor constructor) {
            this.overridesEquals = overridesEquals;
            this.constructor = constructor;
        }

        public boolean isOverridesEquals() {
            return this.overridesEquals;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }
    }
}

