/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import io.quarkus.hibernate.orm.runtime.entitymanager.TransactionScopedEntityManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

@ApplicationScoped
public class TransactionEntityManagers {
    @Inject
    TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    @Inject
    TransactionManager transactionManager;
    @Inject
    JPAConfig jpaConfig;
    @Inject
    Instance<RequestScopedEntityManagerHolder> requestScopedEntityManagers;
    private final ConcurrentMap<String, TransactionScopedEntityManager> managers = new ConcurrentHashMap<String, TransactionScopedEntityManager>();

    public EntityManager getEntityManager(String unitName) {
        TransactionScopedEntityManager entityManager = (TransactionScopedEntityManager)this.managers.get(unitName);
        if (entityManager != null) {
            return entityManager;
        }
        return this.managers.computeIfAbsent(unitName, un -> new TransactionScopedEntityManager(this.transactionManager, this.transactionSynchronizationRegistry, this.jpaConfig.getEntityManagerFactory((String)un), (String)un, this.requestScopedEntityManagers));
    }
}

