/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class QuarkusEnvironment {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Environment.class.getName());
    private static final Map GLOBAL_INITIAL_PROPERTIES;

    public static Map getInitialProperties() {
        return GLOBAL_INITIAL_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            InputStream stream = classLoader.getResourceAsStream("/hibernate.properties");
            if (stream != null) {
                Properties p = new Properties();
                try {
                    p.load(stream);
                }
                catch (Exception e) {
                    LOG.unableToLoadProperties();
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        LOG.unableToCloseStreamError(ioe);
                    }
                }
                GLOBAL_INITIAL_PROPERTIES = p;
            } else {
                LOG.propertiesNotFound();
                GLOBAL_INITIAL_PROPERTIES = new HashMap();
            }
        } else {
            GLOBAL_INITIAL_PROPERTIES = new HashMap();
        }
    }
}

