/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jboss.logging.Logger;

@Singleton
public class JPAConfig {
    private static final Logger LOGGER = Logger.getLogger((String)JPAConfig.class.getName());
    private final AtomicBoolean jtaEnabled = new AtomicBoolean();
    private final Map<String, LazyPersistenceUnit> persistenceUnits = new ConcurrentHashMap<String, LazyPersistenceUnit>();
    private final AtomicReference<String> defaultPersistenceUnitName = new AtomicReference();

    void setJtaEnabled(boolean value) {
        this.jtaEnabled.set(value);
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        if (unitName == null || unitName.isEmpty()) {
            if (this.persistenceUnits.size() == 1) {
                String defaultUnitName = this.defaultPersistenceUnitName.get();
                return defaultUnitName != null ? this.persistenceUnits.get(defaultUnitName).get() : this.persistenceUnits.values().iterator().next().get();
            }
            throw new IllegalStateException("Unable to identify the default PU: " + this.persistenceUnits);
        }
        return this.persistenceUnits.get(unitName).get();
    }

    void registerPersistenceUnit(String unitName) {
        this.persistenceUnits.put(unitName, new LazyPersistenceUnit(unitName));
    }

    void startAll() {
        for (Map.Entry<String, LazyPersistenceUnit> i : this.persistenceUnits.entrySet()) {
            i.getValue().get();
        }
    }

    void initDefaultPersistenceUnit() {
        if (this.persistenceUnits.size() == 1) {
            this.defaultPersistenceUnitName.set(this.persistenceUnits.keySet().iterator().next());
        }
    }

    boolean isJtaEnabled() {
        return this.jtaEnabled.get();
    }

    void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        for (LazyPersistenceUnit factory : this.persistenceUnits.values()) {
            try {
                factory.close();
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to close the EntityManagerFactory: " + factory), (Throwable)e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        this.persistenceUnits.clear();
    }

    static final class LazyPersistenceUnit {
        private final String name;
        private volatile EntityManagerFactory value;
        private volatile boolean closed = false;

        LazyPersistenceUnit(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityManagerFactory get() {
            if (this.value == null) {
                LazyPersistenceUnit lazyPersistenceUnit = this;
                synchronized (lazyPersistenceUnit) {
                    if (this.closed) {
                        throw new IllegalStateException("Persistence unit is closed");
                    }
                    if (this.value == null) {
                        this.value = Persistence.createEntityManagerFactory((String)this.name);
                    }
                }
            }
            return this.value;
        }

        public synchronized void close() {
            this.closed = true;
            EntityManagerFactory emf = this.value;
            this.value = null;
            if (emf != null) {
                emf.close();
            }
        }
    }
}

