/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.boot.FastBootEntityManagerFactoryBuilder;
import io.quarkus.hibernate.orm.runtime.boot.registry.PreconfiguredServiceRegistryBuilder;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrations;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import javax.sql.DataSource;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.service.internal.ProvidedService;
import org.jboss.logging.Logger;

final class FastBootHibernatePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(FastBootHibernatePersistenceProvider.class);
    private final PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private final ProviderUtil providerUtil = new ProviderUtil(){

        public LoadState isLoadedWithoutReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithoutReference((Object)proxy, (String)property, (PersistenceUtilHelper.MetadataCache)FastBootHibernatePersistenceProvider.this.cache);
        }

        public LoadState isLoadedWithReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithReference((Object)proxy, (String)property, (PersistenceUtilHelper.MetadataCache)FastBootHibernatePersistenceProvider.this.cache);
        }

        public LoadState isLoaded(Object o) {
            return PersistenceUtilHelper.isLoaded((Object)o);
        }
    };

    FastBootHibernatePersistenceProvider() {
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        log.tracef("Starting createEntityManagerFactory for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning null");
            return null;
        }
        return builder.build();
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        log.tracef("Starting createContainerEntityManagerFactory : %s", (Object)info.getPersistenceUnitName());
        return this.getEntityManagerFactoryBuilder(info, properties).build();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        log.tracef("Starting generateSchema : PUI.name=%s", (Object)info.getPersistenceUnitName());
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder(info, map);
        builder.generateSchema();
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        log.tracef("Starting generateSchema for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, map);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning false");
            return false;
        }
        builder.generateSchema();
        return true;
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map integration) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", (Object)persistenceUnitName);
        this.verifyProperties(properties);
        List<PersistenceUnitDescriptor> units = PersistenceUnitsHolder.getPersistenceUnitDescriptors();
        log.debugf("Located %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (PersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnit.getProviderClassName(), (Object)persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debugf("Excluding from consideration '%s' due to name mis-match", (Object)persistenceUnit.getName());
                continue;
            }
            if (!this.isProvider(persistenceUnit)) {
                log.debug((Object)"Excluding from consideration due to provider mis-match");
                continue;
            }
            RecordedState recordedState = PersistenceUnitsHolder.getRecordedState(persistenceUnitName);
            PrevalidatedQuarkusMetadata metadata = recordedState.getMetadata();
            BuildTimeSettings buildTimeSettings = recordedState.getBuildTimeSettings();
            IntegrationSettings integrationSettings = recordedState.getIntegrationSettings();
            RuntimeSettings.Builder runtimeSettingsBuilder = new RuntimeSettings.Builder(buildTimeSettings, integrationSettings);
            this.injectDataSource(persistenceUnitName, runtimeSettingsBuilder);
            HibernateOrmIntegrations.contributeRuntimeProperties((k, v) -> runtimeSettingsBuilder.put((String)k, v));
            RuntimeSettings runtimeSettings = runtimeSettingsBuilder.build();
            StandardServiceRegistry standardServiceRegistry = this.rewireMetadataAndExtractServiceRegistry(runtimeSettings, recordedState);
            BeanManager cdiBeanManager = Arc.container().beanManager();
            Object validatorFactory = Arc.container().instance("quarkus-hibernate-validator-factory").get();
            return new FastBootEntityManagerFactoryBuilder(metadata, persistenceUnitName, standardServiceRegistry, runtimeSettings, validatorFactory, cdiBeanManager, recordedState.getMultiTenancyStrategy());
        }
        log.debug((Object)"Found no matching persistence units");
        return null;
    }

    private StandardServiceRegistry rewireMetadataAndExtractServiceRegistry(RuntimeSettings runtimeSettings, RecordedState rs) {
        PreconfiguredServiceRegistryBuilder serviceRegistryBuilder = new PreconfiguredServiceRegistryBuilder(rs);
        runtimeSettings.getSettings().forEach((key, value) -> serviceRegistryBuilder.applySetting((String)key, value));
        for (ProvidedService providedService : rs.getProvidedServices()) {
            serviceRegistryBuilder.addService(providedService);
        }
        StandardServiceRegistryImpl standardServiceRegistry = serviceRegistryBuilder.buildNewServiceRegistry();
        return standardServiceRegistry;
    }

    private boolean isProvider(PersistenceUnitDescriptor persistenceUnit) {
        Map props = Collections.emptyMap();
        String requestedProviderName = FastBootHibernatePersistenceProvider.extractRequestedProviderName(persistenceUnit, props);
        if (requestedProviderName == null) {
            return true;
        }
        return FastBootHibernatePersistenceProvider.class.getName().equals(requestedProviderName) || "org.hibernate.jpa.HibernatePersistenceProvider".equals(requestedProviderName);
    }

    public static String extractRequestedProviderName(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        String integrationProviderName = FastBootHibernatePersistenceProvider.extractProviderName(integration);
        if (integrationProviderName != null) {
            log.debugf("Integration provided explicit PersistenceProvider [%s]", (Object)integrationProviderName);
            return integrationProviderName;
        }
        String persistenceUnitRequestedProvider = FastBootHibernatePersistenceProvider.extractProviderName(persistenceUnit);
        if (persistenceUnitRequestedProvider != null) {
            log.debugf("Persistence-unit [%s] requested PersistenceProvider [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnitRequestedProvider);
            return persistenceUnitRequestedProvider;
        }
        log.debug((Object)"No PersistenceProvider explicitly requested, assuming Hibernate");
        return FastBootHibernatePersistenceProvider.class.getName();
    }

    private static String extractProviderName(Map integration) {
        if (integration == null) {
            return null;
        }
        String setting = (String)integration.get("javax.persistence.provider");
        return setting == null ? null : setting.trim();
    }

    private static String extractProviderName(PersistenceUnitDescriptor persistenceUnit) {
        String persistenceUnitRequestedProvider = persistenceUnit.getProviderClassName();
        return persistenceUnitRequestedProvider == null ? null : persistenceUnitRequestedProvider.trim();
    }

    private void verifyProperties(Map properties) {
        if (properties != null && properties.size() != 0) {
            throw new PersistenceException("The FastbootHibernateProvider PersistenceProvider can not support runtime provided properties. Make sure you set all properties you need in the configuration resources before building the application.");
        }
    }

    private void injectDataSource(String persistenceUnitName, RuntimeSettings.Builder runtimeSettingsBuilder) {
        if (runtimeSettingsBuilder.isConfigured("hibernate.connection.url") || runtimeSettingsBuilder.isConfigured("hibernate.connection.datasource") || runtimeSettingsBuilder.isConfigured("javax.persistence.jtaDataSource") || runtimeSettingsBuilder.isConfigured("javax.persistence.nonJtaDataSource")) {
            return;
        }
        InstanceHandle dataSourceHandle = Arc.container().instance(DataSource.class, new Annotation[0]);
        if (!dataSourceHandle.isAvailable()) {
            throw new IllegalStateException("No datasource has been defined for persistence unit " + persistenceUnitName);
        }
        runtimeSettingsBuilder.put("hibernate.connection.datasource", Arc.container().instance(DataSource.class, new Annotation[0]).get());
    }
}

