/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ResourceReferenceProvider;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.TransactionEntityManagers;
import io.quarkus.hibernate.orm.runtime.entitymanager.ForwardingEntityManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;

public class JPAResourceReferenceProvider
implements ResourceReferenceProvider {
    public InstanceHandle<Object> get(Type type, Set<Annotation> annotations) {
        PersistenceContext pc;
        JPAConfig jpaConfig = (JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get();
        if (EntityManagerFactory.class.equals((Object)type)) {
            PersistenceUnit pu = (PersistenceUnit)this.getAnnotation(annotations, PersistenceUnit.class);
            if (pu != null) {
                return () -> jpaConfig.getEntityManagerFactory(pu.unitName());
            }
        } else if (EntityManager.class.equals((Object)type) && (pc = (PersistenceContext)this.getAnnotation(annotations, PersistenceContext.class)) != null) {
            if (jpaConfig.isJtaEnabled()) {
                final TransactionEntityManagers transactionEntityManagers = (TransactionEntityManagers)Arc.container().instance(TransactionEntityManagers.class, new Annotation[0]).get();
                ForwardingEntityManager entityManager = new ForwardingEntityManager(){

                    @Override
                    protected EntityManager delegate() {
                        return transactionEntityManagers.getEntityManager(pc.unitName());
                    }
                };
                return () -> entityManager;
            }
            EntityManagerFactory entityManagerFactory = jpaConfig.getEntityManagerFactory(pc.unitName());
            final EntityManager entityManager = entityManagerFactory.createEntityManager();
            return new InstanceHandle<Object>(){

                public Object get() {
                    return entityManager;
                }

                public void destroy() {
                    entityManager.close();
                }
            };
        }
        return null;
    }
}

