/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.orm.runtime.Hibernate;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.integrator.spi.Integrator;
import org.jboss.logging.Logger;

@Recorder
public class HibernateOrmRecorder {
    private List<String> entities = new ArrayList<String>();

    public void enlistPersistenceUnit(Set<String> entityClassNames) {
        this.entities.addAll(entityClassNames);
        Logger.getLogger((String)"io.quarkus.hibernate.orm").debugf("List of entities found by Quarkus deployment:%n%s", this.entities);
    }

    public void callHibernateFeatureInit(boolean enabled) {
        Hibernate.featureInit(enabled);
    }

    public BeanContainerListener initializeJpa(final boolean jtaEnabled, final MultiTenancyStrategy strategy, final String multiTenancySchemaDataSource) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                JPAConfig instance = (JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0]);
                instance.setJtaEnabled(jtaEnabled);
                instance.setMultiTenancyStrategy(strategy);
                instance.setMultiTenancySchemaDataSource(multiTenancySchemaDataSource);
            }
        };
    }

    public BeanContainerListener registerPersistenceUnit(final String unitName) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).registerPersistenceUnit(unitName);
            }
        };
    }

    public BeanContainerListener initDefaultPersistenceUnit() {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).initDefaultPersistenceUnit();
            }
        };
    }

    public BeanContainerListener initMetadata(final List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, final Scanner scanner, final Collection<Class<? extends Integrator>> additionalIntegrators, final PreGeneratedProxies proxyDefinitions) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                PersistenceUnitsHolder.initializeJpa(parsedPersistenceXmlDescriptors, scanner, additionalIntegrators, proxyDefinitions);
            }
        };
    }

    public void startAllPersistenceUnits(BeanContainer beanContainer) {
        ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).startAll();
    }
}

