/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.tenant.HibernateCurrentTenantIdentifierResolver;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.internal.SessionFactoryObserverForBytecodeEnhancer;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class FastBootEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    protected final PrevalidatedQuarkusMetadata metadata;
    protected final String persistenceUnitName;
    protected final StandardServiceRegistry standardServiceRegistry;
    private final RuntimeSettings runtimeSettings;
    private final Object validatorFactory;
    private final Object cdiBeanManager;
    protected final MultiTenancyStrategy multiTenancyStrategy;

    public FastBootEntityManagerFactoryBuilder(PrevalidatedQuarkusMetadata metadata, String persistenceUnitName, StandardServiceRegistry standardServiceRegistry, RuntimeSettings runtimeSettings, Object validatorFactory, Object cdiBeanManager, MultiTenancyStrategy strategy) {
        this.metadata = metadata;
        this.persistenceUnitName = persistenceUnitName;
        this.standardServiceRegistry = standardServiceRegistry;
        this.runtimeSettings = runtimeSettings;
        this.validatorFactory = validatorFactory;
        this.cdiBeanManager = cdiBeanManager;
        this.multiTenancyStrategy = strategy;
    }

    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        return null;
    }

    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        return null;
    }

    public EntityManagerFactory build() {
        try {
            SessionFactoryOptionsBuilder optionsBuilder = this.metadata.buildSessionFactoryOptionsBuilder();
            this.populate(optionsBuilder, this.standardServiceRegistry, this.multiTenancyStrategy);
            return new SessionFactoryImpl(this.metadata.getOriginalMetadata(), optionsBuilder.buildOptions(), HQLQueryPlan::new);
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
    }

    public void cancel() {
    }

    public void generateSchema() {
        try {
            SchemaManagementToolCoordinator.process((Metadata)this.metadata, (ServiceRegistry)this.standardServiceRegistry, this.runtimeSettings.getSettings(), (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw this.persistenceException("Error performing schema management", e);
        }
        this.cancel();
    }

    protected PersistenceException persistenceException(String message, Exception cause) {
        for (Throwable t = cause; t != null; t = t.getCause()) {
            if (t instanceof NoSuchAlgorithmException) {
                message = message + "Unable to enable SSL support. You might be in the case where you used the `quarkus.ssl.native=false` configuration and SSL was not disabled automatically for your driver.";
                break;
            }
            if (!(t instanceof CommandAcceptanceException)) continue;
            message = "Invalid import file. Make sure your statements are valid and properly separated by a semi-colon.";
            break;
        }
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnitName + "] ";
    }

    protected void populate(SessionFactoryOptionsBuilder options, StandardServiceRegistry ssr, MultiTenancyStrategy strategy) {
        Object sessionFactoryObserverSetting;
        boolean allowRefreshDetachedEntity;
        boolean jtaTransactionAccessEnabled = this.runtimeSettings.getBoolean("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled) {
            options.disableJtaTransactionAccess();
        }
        if (!(allowRefreshDetachedEntity = this.runtimeSettings.getBoolean("hibernate.allow_refresh_detached_entity"))) {
            options.disableRefreshDetachedEntity();
        }
        if ((sessionFactoryObserverSetting = this.runtimeSettings.get("hibernate.ejb.session_factory_observer")) != null) {
            StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
            SessionFactoryObserver suppliedSessionFactoryObserver = (SessionFactoryObserver)strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            options.addSessionFactoryObservers(new SessionFactoryObserver[]{suppliedSessionFactoryObserver});
        }
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new ServiceRegistryCloser()});
        options.applyEntityNotFoundDelegate((EntityNotFoundDelegate)new JpaEntityNotFoundDelegate());
        if (this.validatorFactory != null) {
            options.applyValidatorFactory(this.validatorFactory);
        }
        if (this.cdiBeanManager != null) {
            options.applyBeanManager(this.cdiBeanManager);
        }
        BytecodeProvider bytecodeProvider = (BytecodeProvider)ssr.getService(BytecodeProvider.class);
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new SessionFactoryObserverForBytecodeEnhancer(bytecodeProvider)});
        if (strategy != null && strategy != MultiTenancyStrategy.NONE) {
            options.applyMultiTenancyStrategy(strategy);
            options.applyCurrentTenantIdentifierResolver((CurrentTenantIdentifierResolver)new HibernateCurrentTenantIdentifierResolver());
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        private JpaEntityNotFoundDelegate() {
        }

        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }

    private static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        private ServiceRegistryCloser() {
        }

        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }
}

