/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.DefaultBean;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

@DefaultBean
@ApplicationScoped
public class DataSourceTenantConnectionResolver
implements TenantConnectionResolver {
    private static final Logger LOG = Logger.getLogger(DataSourceTenantConnectionResolver.class);
    @Inject
    JPAConfig jpaConfig;

    @Override
    public ConnectionProvider resolve(String tenantId) {
        LOG.debugv("resolve({0})", (Object)tenantId);
        MultiTenancyStrategy strategy = this.jpaConfig.getMultiTenancyStrategy();
        LOG.debugv("multitenancy strategy: {0}", (Object)strategy);
        AgroalDataSource dataSource = DataSourceTenantConnectionResolver.tenantDataSource(this.jpaConfig, tenantId, strategy);
        if (dataSource == null) {
            throw new IllegalStateException("No instance of datasource found for tenant: " + tenantId);
        }
        if (strategy == MultiTenancyStrategy.SCHEMA) {
            return new TenantConnectionProvider(tenantId, dataSource);
        }
        return new QuarkusConnectionProvider(dataSource);
    }

    private static AgroalDataSource createFrom(AgroalDataSourceConfiguration config) {
        try {
            return AgroalDataSource.from((AgroalDataSourceConfiguration)config, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Failed to create a new data source based on the default config", ex);
        }
    }

    private static AgroalDataSource tenantDataSource(JPAConfig jpaConfig, String tenantId, MultiTenancyStrategy strategy) {
        if (strategy != MultiTenancyStrategy.SCHEMA) {
            return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(tenantId)}).get();
        }
        String dataSourceName = jpaConfig.getMultiTenancySchemaDataSource();
        if (dataSourceName == null) {
            AgroalDataSource dataSource = (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[0]).get();
            return DataSourceTenantConnectionResolver.createFrom(dataSource.getConfiguration());
        }
        return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(dataSourceName)}).get();
    }

    private static class TenantConnectionProvider
    extends QuarkusConnectionProvider {
        private final String tenantId;

        public TenantConnectionProvider(String tenantId, AgroalDataSource dataSource) {
            super(dataSource);
            this.tenantId = tenantId;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection conn = super.getConnection();
            conn.setSchema(this.tenantId);
            LOG.debugv("Set tenant {0} for connection: {1}", (Object)this.tenantId, (Object)conn);
            return conn;
        }
    }
}

