/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import java.lang.annotation.Annotation;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.jboss.logging.Logger;

public final class HibernateCurrentTenantIdentifierResolver
implements CurrentTenantIdentifierResolver {
    private static final Logger LOG = Logger.getLogger(HibernateCurrentTenantIdentifierResolver.class);

    public String resolveCurrentTenantIdentifier() {
        if (!Arc.container().requestContext().isActive()) {
            return null;
        }
        TenantResolver resolver = HibernateCurrentTenantIdentifierResolver.tenantResolver();
        String tenantId = resolver.resolveTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Method 'TenantResolver.resolveTenantId()' returned a null value. Unfortunately Hibernate ORM does not allow null for tenant identifiers. Please use a non-null value!");
        }
        LOG.debugv("resolveCurrentTenantIdentifier(): {0}", (Object)tenantId);
        return tenantId;
    }

    public boolean validateExistingCurrentSessions() {
        return false;
    }

    private static TenantResolver tenantResolver() {
        InstanceHandle resolverInstance = Arc.container().instance(TenantResolver.class, new Annotation[0]);
        if (!resolverInstance.isAvailable()) {
            throw new IllegalStateException("No instance of " + TenantResolver.class.getName() + " was found. You need to create an implementation for this interface to allow resolving the current tenant identifier.");
        }
        return (TenantResolver)resolverInstance.get();
    }
}

