/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.hibernate.orm.runtime.boot.LightPersistenceXmlDescriptor;
import io.quarkus.runtime.ObjectSubstitution;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class QuarkusPersistenceUnitDefinition {
    private final LightPersistenceXmlDescriptor actualHibernateDescriptor;
    private final String dataSource;
    private final MultiTenancyStrategy multitenancyStrategy;
    private final boolean isReactive;

    public QuarkusPersistenceUnitDefinition(PersistenceUnitDescriptor persistenceUnitDescriptor, String dataSource, MultiTenancyStrategy multitenancyStrategy, boolean isReactive) {
        Objects.requireNonNull(persistenceUnitDescriptor);
        Objects.requireNonNull(multitenancyStrategy);
        this.actualHibernateDescriptor = LightPersistenceXmlDescriptor.validateAndReadFrom(persistenceUnitDescriptor);
        this.dataSource = dataSource;
        this.multitenancyStrategy = multitenancyStrategy;
        this.isReactive = isReactive;
    }

    private QuarkusPersistenceUnitDefinition(LightPersistenceXmlDescriptor persistenceUnitDescriptor, String dataSource, MultiTenancyStrategy multitenancyStrategy, boolean isReactive) {
        Objects.requireNonNull(persistenceUnitDescriptor);
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(multitenancyStrategy);
        this.actualHibernateDescriptor = persistenceUnitDescriptor;
        this.dataSource = dataSource;
        this.multitenancyStrategy = multitenancyStrategy;
        this.isReactive = isReactive;
    }

    public PersistenceUnitDescriptor getActualHibernateDescriptor() {
        return this.actualHibernateDescriptor;
    }

    public String getName() {
        return this.actualHibernateDescriptor.getName();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public MultiTenancyStrategy getMultitenancyStrategy() {
        return this.multitenancyStrategy;
    }

    public boolean isReactive() {
        return this.isReactive;
    }

    public static final class Substitution
    implements ObjectSubstitution<QuarkusPersistenceUnitDefinition, Serialized> {
        public Serialized serialize(QuarkusPersistenceUnitDefinition obj) {
            Serialized s = new Serialized();
            s.setPuName(obj.actualHibernateDescriptor.getName());
            s.setPuProviderClassName(obj.actualHibernateDescriptor.getProviderClassName());
            s.setPuUseQuotedIdentifiers(obj.actualHibernateDescriptor.isUseQuotedIdentifiers());
            s.setPuTransactionType(obj.actualHibernateDescriptor.getTransactionType());
            s.setPuValidationMode(obj.actualHibernateDescriptor.getValidationMode());
            s.setPuSharedCachemode(obj.actualHibernateDescriptor.getSharedCacheMode());
            s.setPuManagedClassNames(obj.actualHibernateDescriptor.getManagedClassNames());
            s.setPuProperties(obj.actualHibernateDescriptor.getProperties());
            s.setDataSource(obj.getDataSource());
            s.setMultitenancyStrategy(obj.getMultitenancyStrategy());
            s.setReactive(obj.isReactive);
            return s;
        }

        public QuarkusPersistenceUnitDefinition deserialize(Serialized obj) {
            LightPersistenceXmlDescriptor xmlDescriptor = new LightPersistenceXmlDescriptor(obj.puName, obj.puProviderClassName, obj.puUseQuotedIdentifiers, obj.puTransactionType, obj.puValidationMode, obj.puSharedCachemode, obj.puManagedClassNames, obj.puProperties);
            return new QuarkusPersistenceUnitDefinition(xmlDescriptor, obj.getDataSource(), obj.getMultitenancyStrategy(), obj.isReactive());
        }
    }

    public static class Serialized {
        private String dataSource;
        private MultiTenancyStrategy multitenancyStrategy;
        private boolean isReactive;
        private String puName;
        private String puProviderClassName;
        private boolean puUseQuotedIdentifiers;
        private PersistenceUnitTransactionType puTransactionType;
        private ValidationMode puValidationMode;
        private SharedCacheMode puSharedCachemode;
        private List<String> puManagedClassNames;
        private Properties puProperties;

        public String getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public String getPuName() {
            return this.puName;
        }

        public void setPuName(String puName) {
            this.puName = puName;
        }

        public MultiTenancyStrategy getMultitenancyStrategy() {
            return this.multitenancyStrategy;
        }

        public void setMultitenancyStrategy(MultiTenancyStrategy multitenancyStrategy) {
            this.multitenancyStrategy = multitenancyStrategy;
        }

        public boolean isReactive() {
            return this.isReactive;
        }

        public void setReactive(boolean reactive) {
            this.isReactive = reactive;
        }

        public String getPuProviderClassName() {
            return this.puProviderClassName;
        }

        public void setPuProviderClassName(String puProviderClassName) {
            this.puProviderClassName = puProviderClassName;
        }

        public boolean isPuUseQuotedIdentifiers() {
            return this.puUseQuotedIdentifiers;
        }

        public void setPuUseQuotedIdentifiers(boolean puUseQuotedIdentifiers) {
            this.puUseQuotedIdentifiers = puUseQuotedIdentifiers;
        }

        public PersistenceUnitTransactionType getPuTransactionType() {
            return this.puTransactionType;
        }

        public void setPuTransactionType(PersistenceUnitTransactionType puTransactionType) {
            this.puTransactionType = puTransactionType;
        }

        public ValidationMode getPuValidationMode() {
            return this.puValidationMode;
        }

        public void setPuValidationMode(ValidationMode puValidationMode) {
            this.puValidationMode = puValidationMode;
        }

        public SharedCacheMode getPuSharedCachemode() {
            return this.puSharedCachemode;
        }

        public void setPuSharedCachemode(SharedCacheMode puSharedCachemode) {
            this.puSharedCachemode = puSharedCachemode;
        }

        public List<String> getPuManagedClassNames() {
            return this.puManagedClassNames;
        }

        public void setPuManagedClassNames(List<String> puManagedClassNames) {
            this.puManagedClassNames = puManagedClassNames;
        }

        public Properties getPuProperties() {
            return this.puProperties;
        }

        public void setPuProperties(Properties puProperties) {
            this.puProperties = puProperties;
        }
    }
}

