/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.metrics;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.metrics.HibernateMicrometerMetrics;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.metrics.MetricsFactory;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;

@Recorder
public class HibernateMetricsRecorder {
    private static final String SESSION_FACTORY_TAG_NAME = "entityManagerFactory";

    public Consumer<MetricsFactory> registerMicrometerMetrics() {
        return new Consumer<MetricsFactory>(){

            @Override
            public void accept(MetricsFactory metricsFactory) {
                JPAConfig jpaConfig = (JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get();
                for (String puName : jpaConfig.getPersistenceUnits()) {
                    SessionFactory sessionFactory = (SessionFactory)jpaConfig.getEntityManagerFactory(puName).unwrap(SessionFactory.class);
                    if (sessionFactory == null) continue;
                    HibernateMicrometerMetrics.registerMeterBinders(puName, sessionFactory);
                }
            }
        };
    }

    public Consumer<MetricsFactory> registerMPMetrics() {
        return new Consumer<MetricsFactory>(){

            @Override
            public void accept(MetricsFactory metricsFactory) {
                JPAConfig jpaConfig = (JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get();
                for (String puName : jpaConfig.getPersistenceUnits()) {
                    SessionFactory sessionFactory = (SessionFactory)jpaConfig.getEntityManagerFactory(puName).unwrap(SessionFactory.class);
                    if (sessionFactory == null) continue;
                    HibernateMetricsRecorder.this.registerMetrics(metricsFactory, puName, sessionFactory.getStatistics());
                }
            }
        };
    }

    void registerMetrics(MetricsFactory metricsFactory, String puName, Statistics statistics) {
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.sessions.open", "Global number of sessions opened", puName, statistics, Statistics::getSessionOpenCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.sessions.closed", "Global number of sessions closed", puName, statistics, Statistics::getSessionCloseCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.transactions", "The number of transactions we know to have completed", puName, statistics, Statistics::getTransactionCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.transactions.successful", "The number of transactions we know to have been successful", puName, statistics, Statistics::getSuccessfulTransactionCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.optimistic.lock.failures", "The number of Hibernate StaleObjectStateExceptions or JPA OptimisticLockExceptions that occurred.", puName, statistics, Statistics::getOptimisticFailureCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.flushes", "Global number of flush operations executed (either manual or automatic).", puName, statistics, Statistics::getFlushCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.connections.obtained", "Get the global number of connections asked by the sessions (the actual number of connections used may be much smaller depending whether you use a connection pool or not)", puName, statistics, Statistics::getConnectCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.statements.prepared", "The number of prepared statements that were acquired", puName, statistics, Statistics::getPrepareStatementCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.statements.closed", "The number of prepared statements that were released", puName, statistics, Statistics::getCloseStatementCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.second-level-cache.puts", "Global number of cacheable entities/collections put in the cache", puName, statistics, Statistics::getSecondLevelCachePutCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.second-level-cache.hits", "Global number of cacheable entities/collections successfully retrieved from the cache", puName, statistics, Statistics::getSecondLevelCacheHitCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.second-level-cache.misses", "Global number of cacheable entities/collections not found in the cache and loaded from the database.", puName, statistics, Statistics::getSecondLevelCacheMissCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.entities.loaded", "Global number of entity loads", puName, statistics, Statistics::getEntityLoadCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.entities.updated", "Global number of entity updates", puName, statistics, Statistics::getEntityUpdateCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.entities.inserted", "Global number of entity inserts", puName, statistics, Statistics::getEntityInsertCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.entities.deleted", "Global number of entity deletes", puName, statistics, Statistics::getEntityDeleteCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.entities.fetched", "Global number of entity fetches", puName, statistics, Statistics::getEntityFetchCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.collections.loaded", "Global number of collections loaded", puName, statistics, Statistics::getCollectionLoadCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.collections.updated", "Global number of collections updated", puName, statistics, Statistics::getCollectionUpdateCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.collections.removed", "Global number of collections removed", puName, statistics, Statistics::getCollectionRemoveCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.collections.recreated", "Global number of collections recreated", puName, statistics, Statistics::getCollectionRecreateCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.collections.fetched", "Global number of collections fetched", puName, statistics, Statistics::getCollectionFetchCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.natural-id.queries.executions", "Global number of natural id queries executed against the database", puName, statistics, Statistics::getNaturalIdQueryExecutionCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.natural-id.cache.hits", "Global number of cached natural id lookups successfully retrieved from cache", puName, statistics, Statistics::getNaturalIdCacheHitCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.natural-id.cache.puts", "Global number of cacheable natural id lookups put in cache", puName, statistics, Statistics::getNaturalIdCachePutCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.natural-id.cache.misses", "Global number of cached natural id lookups *not* found in cache", puName, statistics, Statistics::getNaturalIdCacheMissCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.queries.executed", "Global number of executed queries", puName, statistics, Statistics::getQueryExecutionCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.query-cache.puts", "Global number of cacheable queries put in cache", puName, statistics, Statistics::getQueryCachePutCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.query-cache.hits", "Global number of cached queries successfully retrieved from cache", puName, statistics, Statistics::getQueryCacheHitCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.query-cache.misses", "Global number of cached queries *not* found in cache", puName, statistics, Statistics::getQueryCacheMissCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.timestamps-cache.puts", "Global number of timestamps put in cache", puName, statistics, Statistics::getUpdateTimestampsCachePutCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.timestamps-cache.hits", "Global number of timestamps successfully retrieved from cache", puName, statistics, Statistics::getUpdateTimestampsCacheHitCount);
        this.createStatisticsCounter(metricsFactory, "hibernate-orm.timestamps-cache.misses", "Global number of timestamp requests that were not found in the cache", puName, statistics, Statistics::getUpdateTimestampsCacheMissCount);
    }

    void createStatisticsCounter(MetricsFactory metricsFactory, String metricName, String description, String puName, Statistics statistics, Function<Statistics, Long> f) {
        metricsFactory.builder(metricName).description(description).tag(SESSION_FACTORY_TAG_NAME, puName).buildCounter((Object)statistics, f);
    }
}

