/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.ProviderUtil;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.boot.FastBootEntityManagerFactoryBuilder;
import io.quarkus.hibernate.orm.runtime.boot.registry.PreconfiguredServiceRegistryBuilder;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.service.internal.ProvidedService;
import org.jboss.logging.Logger;

public final class FastBootHibernatePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(FastBootHibernatePersistenceProvider.class);
    private final ProviderUtil providerUtil = new ProviderUtil();
    private final HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig;
    private final Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors;

    public FastBootHibernatePersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        this.hibernateOrmRuntimeConfig = hibernateOrmRuntimeConfig;
        this.integrationRuntimeDescriptors = integrationRuntimeDescriptors;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        log.tracef("Starting createEntityManagerFactory for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning null");
            return null;
        }
        return builder.build();
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        log.tracef("Starting createContainerEntityManagerFactory : %s", (Object)info.getPersistenceUnitName());
        return this.getEntityManagerFactoryBuilder(info, properties).build();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        log.tracef("Starting generateSchema : PUI.name=%s", (Object)info.getPersistenceUnitName());
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder(info, map);
        builder.generateSchema();
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        log.tracef("Starting generateSchema for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, map);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning false");
            return false;
        }
        builder.generateSchema();
        return true;
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }

    public EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map integration) {
        return this.getEntityManagerFactoryBuilder(info.getPersistenceUnitName(), integration);
    }

    public EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(String persistenceUnitName, Map integration) {
        return this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, integration);
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", (Object)persistenceUnitName);
        this.verifyProperties(properties);
        List<PersistenceUnitDescriptor> units = PersistenceUnitsHolder.getPersistenceUnitDescriptors();
        log.debugf("Located %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (PersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnit.getProviderClassName(), (Object)persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debugf("Excluding from consideration '%s' due to name mis-match", (Object)persistenceUnit.getName());
                continue;
            }
            if (!this.isProvider(persistenceUnit)) {
                log.debug((Object)"Excluding from consideration due to provider mis-match");
                continue;
            }
            RecordedState recordedState = PersistenceUnitsHolder.popRecordedState(persistenceUnitName);
            if (recordedState.isReactive()) {
                throw new IllegalStateException("Attempting to boot a blocking Hibernate ORM instance on a reactive RecordedState");
            }
            PrevalidatedQuarkusMetadata metadata = recordedState.getMetadata();
            BuildTimeSettings buildTimeSettings = recordedState.getBuildTimeSettings();
            IntegrationSettings integrationSettings = recordedState.getIntegrationSettings();
            RuntimeSettings.Builder runtimeSettingsBuilder = new RuntimeSettings.Builder(buildTimeSettings, integrationSettings);
            FastBootHibernatePersistenceProvider.injectDataSource(persistenceUnitName, recordedState.getDataSource(), runtimeSettingsBuilder);
            if (!recordedState.isFromPersistenceXml()) {
                FastBootHibernatePersistenceProvider.injectRuntimeConfiguration(persistenceUnitName, this.hibernateOrmRuntimeConfig, runtimeSettingsBuilder);
            }
            for (HibernateOrmIntegrationRuntimeDescriptor descriptor : this.integrationRuntimeDescriptors.getOrDefault(persistenceUnitName, Collections.emptyList())) {
                Optional<HibernateOrmIntegrationRuntimeInitListener> listenerOptional = descriptor.getInitListener();
                if (!listenerOptional.isPresent()) continue;
                listenerOptional.get().contributeRuntimeProperties(runtimeSettingsBuilder::put);
            }
            runtimeSettingsBuilder.put("hibernate.temp.use_jdbc_metadata_defaults", "true");
            RuntimeSettings runtimeSettings = runtimeSettingsBuilder.build();
            StandardServiceRegistry standardServiceRegistry = this.rewireMetadataAndExtractServiceRegistry(runtimeSettings, recordedState);
            BeanManager cdiBeanManager = Arc.container().beanManager();
            Object validatorFactory = Arc.container().instance("quarkus-hibernate-validator-factory").get();
            return new FastBootEntityManagerFactoryBuilder(metadata, persistenceUnitName, standardServiceRegistry, runtimeSettings, validatorFactory, cdiBeanManager, recordedState.getMultiTenancyStrategy());
        }
        log.debug((Object)"Found no matching persistence units");
        return null;
    }

    private StandardServiceRegistry rewireMetadataAndExtractServiceRegistry(RuntimeSettings runtimeSettings, RecordedState rs) {
        PreconfiguredServiceRegistryBuilder serviceRegistryBuilder = new PreconfiguredServiceRegistryBuilder(rs);
        runtimeSettings.getSettings().forEach((key, value) -> serviceRegistryBuilder.applySetting((String)key, value));
        for (ProvidedService providedService : rs.getProvidedServices()) {
            serviceRegistryBuilder.addService(providedService);
        }
        StandardServiceRegistryImpl standardServiceRegistry = serviceRegistryBuilder.buildNewServiceRegistry();
        return standardServiceRegistry;
    }

    private boolean isProvider(PersistenceUnitDescriptor persistenceUnit) {
        Map props = Collections.emptyMap();
        String requestedProviderName = FastBootHibernatePersistenceProvider.extractRequestedProviderName(persistenceUnit, props);
        if (requestedProviderName == null) {
            return true;
        }
        return FastBootHibernatePersistenceProvider.class.getName().equals(requestedProviderName) || "org.hibernate.jpa.HibernatePersistenceProvider".equals(requestedProviderName);
    }

    public static String extractRequestedProviderName(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        String integrationProviderName = FastBootHibernatePersistenceProvider.extractProviderName(integration);
        if (integrationProviderName != null) {
            log.debugf("Integration provided explicit PersistenceProvider [%s]", (Object)integrationProviderName);
            return integrationProviderName;
        }
        String persistenceUnitRequestedProvider = FastBootHibernatePersistenceProvider.extractProviderName(persistenceUnit);
        if (persistenceUnitRequestedProvider != null) {
            log.debugf("Persistence-unit [%s] requested PersistenceProvider [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnitRequestedProvider);
            return persistenceUnitRequestedProvider;
        }
        log.debug((Object)"No PersistenceProvider explicitly requested, assuming Hibernate");
        return FastBootHibernatePersistenceProvider.class.getName();
    }

    private static String extractProviderName(Map integration) {
        if (integration == null) {
            return null;
        }
        String setting = (String)integration.get("javax.persistence.provider");
        return setting == null ? null : setting.trim();
    }

    private static String extractProviderName(PersistenceUnitDescriptor persistenceUnit) {
        String persistenceUnitRequestedProvider = persistenceUnit.getProviderClassName();
        return persistenceUnitRequestedProvider == null ? null : persistenceUnitRequestedProvider.trim();
    }

    private void verifyProperties(Map properties) {
        if (properties != null && properties.size() != 0) {
            throw new PersistenceException("The FastbootHibernateProvider PersistenceProvider can not support runtime provided properties. Make sure you set all properties you need in the configuration resources before building the application.");
        }
    }

    private static void injectDataSource(String persistenceUnitName, String dataSource, RuntimeSettings.Builder runtimeSettingsBuilder) {
        if (runtimeSettingsBuilder.isConfigured("hibernate.connection.url") || runtimeSettingsBuilder.isConfigured("hibernate.connection.datasource") || runtimeSettingsBuilder.isConfigured("javax.persistence.jtaDataSource") || runtimeSettingsBuilder.isConfigured("javax.persistence.nonJtaDataSource")) {
            return;
        }
        InstanceHandle dataSourceHandle = DataSourceUtil.isDefault((String)dataSource) ? Arc.container().instance(DataSource.class, new Annotation[0]) : Arc.container().instance(DataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(dataSource)});
        if (!dataSourceHandle.isAvailable()) {
            throw new IllegalStateException("No datasource " + dataSource + " has been defined for persistence unit " + persistenceUnitName);
        }
        DataSource ds = (DataSource)dataSourceHandle.get();
        if (ds instanceof UnconfiguredDataSource) {
            throw new ConfigurationException("Model classes are defined for the default persistence unit " + persistenceUnitName + " but configured datasource " + dataSource + " not found: the default EntityManagerFactory will not be created. To solve this, configure the default datasource. Refer to https://quarkus.io/guides/datasource for guidance.");
        }
        runtimeSettingsBuilder.put("hibernate.connection.datasource", ds);
    }

    private static void injectRuntimeConfiguration(String persistenceUnitName, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, RuntimeSettings.Builder runtimeSettingsBuilder) {
        HibernateOrmRuntimeConfigPersistenceUnit persistenceUnitConfig = PersistenceUnitUtil.isDefaultPersistenceUnit(persistenceUnitName) ? hibernateOrmRuntimeConfig.defaultPersistenceUnit : hibernateOrmRuntimeConfig.persistenceUnits.getOrDefault(persistenceUnitName, new HibernateOrmRuntimeConfigPersistenceUnit());
        runtimeSettingsBuilder.put("javax.persistence.schema-generation.database.action", persistenceUnitConfig.database.generation.generation);
        runtimeSettingsBuilder.put("javax.persistence.create-database-schemas", String.valueOf(persistenceUnitConfig.database.generation.createSchemas));
        if (persistenceUnitConfig.database.generation.haltOnError) {
            runtimeSettingsBuilder.put("hibernate.hbm2ddl.halt_on_error", "true");
        }
        runtimeSettingsBuilder.put("javax.persistence.schema-generation.scripts.action", persistenceUnitConfig.scripts.generation.generation);
        if (persistenceUnitConfig.scripts.generation.createTarget.isPresent()) {
            runtimeSettingsBuilder.put("javax.persistence.schema-generation.scripts.create-target", persistenceUnitConfig.scripts.generation.createTarget.get());
        }
        if (persistenceUnitConfig.scripts.generation.dropTarget.isPresent()) {
            runtimeSettingsBuilder.put("javax.persistence.schema-generation.scripts.drop-target", persistenceUnitConfig.scripts.generation.dropTarget.get());
        }
        if (persistenceUnitConfig.log.sql) {
            runtimeSettingsBuilder.put("hibernate.show_sql", "true");
            if (persistenceUnitConfig.log.formatSql) {
                runtimeSettingsBuilder.put("hibernate.format_sql", "true");
            }
        }
        if (persistenceUnitConfig.log.jdbcWarnings.isPresent()) {
            runtimeSettingsBuilder.put("hibernate.jdbc.log.warnings", persistenceUnitConfig.log.jdbcWarnings.get().toString());
        }
    }
}

