/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.infinispan.quarkus.hibernate.cache.QuarkusInfinispanRegionFactory;

public final class QuarkusRegionFactoryInitiator
implements StandardServiceInitiator<RegionFactory> {
    public static final QuarkusRegionFactoryInitiator INSTANCE = new QuarkusRegionFactoryInitiator();

    private QuarkusRegionFactoryInitiator() {
    }

    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    public RegionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Boolean useSecondLevelCache = ConfigurationHelper.getBooleanWrapper((String)"hibernate.cache.use_second_level_cache", (Map)configurationValues, (Boolean)Boolean.TRUE);
        Boolean useQueryCache = ConfigurationHelper.getBooleanWrapper((String)"hibernate.cache.use_query_cache", (Map)configurationValues, (Boolean)Boolean.TRUE);
        if (useSecondLevelCache != null && useSecondLevelCache == Boolean.FALSE && (useQueryCache == null || useQueryCache == Boolean.FALSE)) {
            return NoCachingRegionFactory.INSTANCE;
        }
        return new QuarkusInfinispanRegionFactory();
    }
}

