/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.config.DatabaseOrmCompatibilityVersion;
import java.util.Map;

public class BuildTimeSettings {
    private Map<String, Object> quarkusConfigSettings;
    private DatabaseOrmCompatibilityVersion databaseOrmCompatibilityVersion;
    private Map<String, String> databaseOrmCompatibilitySettings;
    private Map<String, Object> allSettings;

    public BuildTimeSettings(Map<String, Object> quarkusConfigSettings, DatabaseOrmCompatibilityVersion databaseOrmCompatibilityVersion, Map<String, String> databaseOrmCompatibilitySettings, Map<String, Object> allSettings) {
        this.quarkusConfigSettings = Map.copyOf(quarkusConfigSettings);
        this.databaseOrmCompatibilityVersion = databaseOrmCompatibilityVersion;
        this.databaseOrmCompatibilitySettings = Map.copyOf(databaseOrmCompatibilitySettings);
        this.allSettings = Map.copyOf(allSettings);
    }

    public Object get(String key) {
        return this.allSettings.get(key);
    }

    public boolean getBoolean(String key) {
        Object propertyValue = this.allSettings.get(key);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    public boolean isConfigured(String key) {
        return this.allSettings.containsKey(key);
    }

    public Map<String, Object> getQuarkusConfigSettings() {
        return this.quarkusConfigSettings;
    }

    public DatabaseOrmCompatibilityVersion getDatabaseOrmCompatibilityVersion() {
        return this.databaseOrmCompatibilityVersion;
    }

    public Map<String, String> getDatabaseOrmCompatibilitySettings() {
        return this.databaseOrmCompatibilitySettings;
    }

    public Map<String, Object> getAllSettings() {
        return this.allSettings;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.allSettings.toString() + "}";
    }
}

