/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.orm.runtime.Hibernate;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceProviderSetup;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.StatelessSessionLazyDelegator;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.schema.SchemaManagementIntegrator;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.engine.spi.SessionLazyDelegator;
import org.hibernate.integrator.spi.Integrator;
import org.jboss.logging.Logger;

@Recorder
public class HibernateOrmRecorder {
    private final PreGeneratedProxies proxyDefinitions;
    private final List<String> entities = new ArrayList<String>();

    @Inject
    public HibernateOrmRecorder(PreGeneratedProxies proxyDefinitions) {
        this.proxyDefinitions = proxyDefinitions;
    }

    public void enlistPersistenceUnit(Set<String> entityClassNames) {
        this.entities.addAll(entityClassNames);
        Logger.getLogger((String)"io.quarkus.hibernate.orm").debugf("List of entities found by Quarkus deployment:%n%s", this.entities);
    }

    public void callHibernateFeatureInit(boolean enabled) {
        Hibernate.featureInit(enabled);
    }

    public void setupPersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        PersistenceProviderSetup.registerRuntimePersistenceProvider(hibernateOrmRuntimeConfig, integrationRuntimeDescriptors);
    }

    public BeanContainerListener initMetadata(final List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, final Scanner scanner, final Collection<Class<? extends Integrator>> additionalIntegrators) {
        SchemaManagementIntegrator.clearDsMap();
        for (QuarkusPersistenceUnitDefinition i : parsedPersistenceXmlDescriptors) {
            if (!i.getDataSource().isPresent()) continue;
            SchemaManagementIntegrator.mapDatasource(i.getDataSource().get(), i.getName());
        }
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                PersistenceUnitsHolder.initializeJpa(parsedPersistenceXmlDescriptors, scanner, additionalIntegrators, HibernateOrmRecorder.this.proxyDefinitions);
            }
        };
    }

    public Supplier<DataSourceTenantConnectionResolver> dataSourceTenantConnectionResolver(final String persistenceUnitName, final Optional<String> dataSourceName, final MultiTenancyStrategy multiTenancyStrategy, final String multiTenancySchemaDataSourceName) {
        return new Supplier<DataSourceTenantConnectionResolver>(){

            @Override
            public DataSourceTenantConnectionResolver get() {
                return new DataSourceTenantConnectionResolver(persistenceUnitName, dataSourceName, multiTenancyStrategy, multiTenancySchemaDataSourceName);
            }
        };
    }

    public void startAllPersistenceUnits(BeanContainer beanContainer) {
        ((JPAConfig)beanContainer.beanInstance(JPAConfig.class, new Annotation[0])).startAll();
    }

    public Function<SyntheticCreationalContext<SessionFactory>, SessionFactory> sessionFactorySupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<SessionFactory>, SessionFactory>(){

            @Override
            public SessionFactory apply(SyntheticCreationalContext<SessionFactory> context) {
                SessionFactory sessionFactory = (SessionFactory)((JPAConfig)context.getInjectedReference(JPAConfig.class, new Annotation[0])).getEntityManagerFactory(persistenceUnitName).unwrap(SessionFactory.class);
                return sessionFactory;
            }
        };
    }

    public Function<SyntheticCreationalContext<Session>, Session> sessionSupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<Session>, Session>(){

            @Override
            public Session apply(SyntheticCreationalContext<Session> context) {
                final TransactionSessions transactionSessions = (TransactionSessions)context.getInjectedReference(TransactionSessions.class, new Annotation[0]);
                return new SessionLazyDelegator((Supplier)new Supplier<Session>(){

                    @Override
                    public Session get() {
                        return transactionSessions.getSession(persistenceUnitName);
                    }
                });
            }
        };
    }

    public Function<SyntheticCreationalContext<StatelessSession>, StatelessSession> statelessSessionSupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<StatelessSession>, StatelessSession>(){

            @Override
            public StatelessSession apply(SyntheticCreationalContext<StatelessSession> context) {
                final TransactionSessions transactionSessions = (TransactionSessions)context.getInjectedReference(TransactionSessions.class, new Annotation[0]);
                return new StatelessSessionLazyDelegator(new Supplier<StatelessSession>(){

                    @Override
                    public StatelessSession get() {
                        return transactionSessions.getStatelessSession(persistenceUnitName);
                    }
                });
            }
        };
    }

    public void doValidation(final String puName) {
        Optional val = puName.equals("<default>") ? ConfigProvider.getConfig().getOptionalValue("quarkus.hibernate-orm.database.generation", String.class) : ConfigProvider.getConfig().getOptionalValue("quarkus.hibernate-orm.\"" + puName + "\".database.generation", String.class);
        if (val.isPresent() && !((String)val.get()).equals("none")) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SchemaManagementIntegrator.runPostBootValidation(puName);
            }
        }, "Hibernate post-boot validation thread for " + puName).start();
    }
}

