/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect;
import java.util.Objects;
import org.hibernate.boot.registry.selector.internal.DefaultDialectSelector;
import org.hibernate.dialect.Dialect;
import org.jboss.logging.Logger;

final class QuarkusDialectSelector
extends DefaultDialectSelector {
    QuarkusDialectSelector() {
    }

    public Class<? extends Dialect> resolve(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            return null;
        }
        switch (name) {
            case "org.hibernate.dialect.H2Dialect": {
                Logger.getLogger(QuarkusDialectSelector.class).warn((Object)("Overriding dialect choice: 'org.hibernate.dialect.H2Dialect' will be replaced with '" + QuarkusH2Dialect.class.getName() + "' to ensure compatibility with the bundled version of H2."));
            }
            case "H2": {
                return QuarkusH2Dialect.class;
            }
        }
        return super.resolve(name);
    }
}

