/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.devconsole;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.boot.spi.AbstractNamedQueryDefinition;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerCollectingImpl;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class HibernateOrmDevConsoleInfoSupplier
implements Supplier<PersistenceUnitsInfo> {
    public static final PersistenceUnitsInfo INSTANCE = new PersistenceUnitsInfo();

    public static void pushPersistenceUnit(String persistenceUnitName, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
        ArrayList<EntityInfo> managedEntities = new ArrayList<EntityInfo>();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            managedEntities.add(new EntityInfo(entityBinding.getClassName(), entityBinding.getTable().getName()));
        }
        ArrayList<QueryInfo> namedQueries = new ArrayList<QueryInfo>();
        ArrayList namedQueriesHqlDefs = new ArrayList();
        metadata.visitNamedHqlQueryDefinitions(namedQueriesHqlDefs::add);
        for (Object queryDefinition : namedQueriesHqlDefs) {
            namedQueries.add(new QueryInfo((NamedHqlQueryDefinition)queryDefinition));
        }
        ArrayList<QueryInfo> namedNativeQueries = new ArrayList<QueryInfo>();
        ArrayList namedNativeQueriesNativeDefs = new ArrayList();
        metadata.visitNamedNativeQueryDefinitions(namedNativeQueriesNativeDefs::add);
        for (NamedNativeQueryDefinition staticQueryDefinition : namedNativeQueriesNativeDefs) {
            namedNativeQueries.add(new QueryInfo(staticQueryDefinition));
        }
        String createDDL = HibernateOrmDevConsoleInfoSupplier.generateDDL(Action.CREATE, metadata, serviceRegistry, importFile);
        String dropDDL = HibernateOrmDevConsoleInfoSupplier.generateDDL(Action.DROP, metadata, serviceRegistry, importFile);
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.persistenceUnits.put(persistenceUnitName, new PersistenceUnitInfo(persistenceUnitName, managedEntities, namedQueries, namedNativeQueries, createDDL, dropDDL));
    }

    public static void clearData() {
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.persistenceUnits.clear();
    }

    private static String generateDDL(Action action, Metadata metadata, ServiceRegistry ssr, String importFiles) {
        HibernateSchemaManagementTool tool = (HibernateSchemaManagementTool)ssr.getService(SchemaManagementTool.class);
        HashMap<String, Object> config = new HashMap<String, Object>(((ConfigurationService)ssr.getService(ConfigurationService.class)).getSettings());
        config.put("hibernate.hbm2ddl.delimiter", ";");
        config.put("hibernate.format_sql", true);
        config.put("hibernate.hbm2ddl.import_files", importFiles);
        ExceptionHandlerCollectingImpl exceptionHandler = new ExceptionHandlerCollectingImpl();
        try {
            ExecutionOptions executionOptions = SchemaManagementToolCoordinator.buildExecutionOptions(config, (ExceptionHandler)exceptionHandler);
            final StringWriter writer = new StringWriter();
            SourceDescriptor source = new SourceDescriptor(){

                public SourceType getSourceType() {
                    return SourceType.METADATA;
                }

                public ScriptSourceInput getScriptSourceInput() {
                    return null;
                }
            };
            TargetDescriptor target = new TargetDescriptor(){

                public EnumSet<TargetType> getTargetTypes() {
                    return EnumSet.of(TargetType.SCRIPT);
                }

                public ScriptTargetOutput getScriptTargetOutput() {
                    return new ScriptTargetOutputToWriter(writer){

                        public void accept(String command) {
                            super.accept(command);
                        }
                    };
                }
            };
            if (action == Action.DROP) {
                SchemaDropper schemaDropper = tool.getSchemaDropper(executionOptions.getConfigurationValues());
                schemaDropper.doDrop(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            } else if (action == Action.CREATE) {
                SchemaCreator schemaDropper = tool.getSchemaCreator(executionOptions.getConfigurationValues());
                schemaDropper.doCreation(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            }
            return writer.toString();
        }
        catch (RuntimeException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            return "Could not generate DDL: \n" + stackTraceWriter.toString();
        }
    }

    @Override
    public PersistenceUnitsInfo get() {
        return INSTANCE;
    }

    private static boolean extractIsCacheable(NamedQueryDefinition definition) {
        AbstractNamedQueryDefinition def;
        return definition instanceof AbstractNamedQueryDefinition && (def = (AbstractNamedQueryDefinition)definition).getCacheable() == Boolean.TRUE;
    }

    private static String extractLockOptions(NamedQueryDefinition definition) {
        AbstractNamedQueryDefinition def;
        LockOptions lockOptions;
        if (definition instanceof AbstractNamedQueryDefinition && (lockOptions = (def = (AbstractNamedQueryDefinition)definition).getLockOptions()) != null && lockOptions.getLockMode() != null) {
            return lockOptions.getLockMode().name();
        }
        return "";
    }

    public static class QueryInfo {
        private final String name;
        private final String query;
        private final boolean cacheable;
        private final String lockMode;
        private final String type;

        public QueryInfo(NamedHqlQueryDefinition queryDefinition) {
            this.name = queryDefinition.getRegistrationName();
            this.query = queryDefinition.getHqlString();
            this.cacheable = HibernateOrmDevConsoleInfoSupplier.extractIsCacheable((NamedQueryDefinition)queryDefinition);
            this.lockMode = HibernateOrmDevConsoleInfoSupplier.extractLockOptions((NamedQueryDefinition)queryDefinition);
            this.type = "JPQL";
        }

        public QueryInfo(NamedNativeQueryDefinition nativeQueryDefinition) {
            this.name = nativeQueryDefinition.getRegistrationName();
            this.query = nativeQueryDefinition.getSqlQueryString();
            this.cacheable = HibernateOrmDevConsoleInfoSupplier.extractIsCacheable((NamedQueryDefinition)nativeQueryDefinition);
            this.lockMode = HibernateOrmDevConsoleInfoSupplier.extractLockOptions((NamedQueryDefinition)nativeQueryDefinition);
            this.type = "native";
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class EntityInfo {
        private final String className;
        private final String tableName;

        public EntityInfo(String className, String tableName) {
            this.className = className;
            this.tableName = tableName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class PersistenceUnitInfo {
        private final String name;
        private final List<EntityInfo> managedEntities;
        private final List<QueryInfo> namedQueries;
        private final List<QueryInfo> namedNativeQueries;
        private final String createDDL;
        private final String dropDDL;

        public PersistenceUnitInfo(String name, List<EntityInfo> managedEntities, List<QueryInfo> namedQueries, List<QueryInfo> namedNativeQueries, String createDDL, String dropDDL) {
            this.name = name;
            this.managedEntities = managedEntities;
            this.namedQueries = namedQueries;
            this.namedNativeQueries = namedNativeQueries;
            this.createDDL = createDDL;
            this.dropDDL = dropDDL;
        }

        public String getName() {
            return this.name;
        }

        public List<EntityInfo> getManagedEntities() {
            return this.managedEntities;
        }

        public List<QueryInfo> getNamedQueries() {
            return this.namedQueries;
        }

        public List<QueryInfo> getNamedNativeQueries() {
            return this.namedNativeQueries;
        }

        public List<QueryInfo> getAllNamedQueries() {
            ArrayList<QueryInfo> allQueries = new ArrayList<QueryInfo>();
            allQueries.addAll(this.namedQueries);
            allQueries.addAll(this.namedNativeQueries);
            return allQueries;
        }

        public String getCreateDDL() {
            return this.createDDL;
        }

        public String getDropDDL() {
            return this.dropDDL;
        }
    }

    public static class PersistenceUnitsInfo {
        private final Map<String, PersistenceUnitInfo> persistenceUnits = Collections.synchronizedMap(new TreeMap(new PersistenceUnitUtil.PersistenceUnitNameComparator()));

        public Collection<PersistenceUnitInfo> getPersistenceUnits() {
            return this.persistenceUnits.values();
        }

        public int getNumberOfNamedQueries() {
            return this.persistenceUnits.values().stream().map(PersistenceUnitInfo::getAllNamedQueries).mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }

        public int getNumberOfEntities() {
            return this.persistenceUnits.values().stream().map(PersistenceUnitInfo::getManagedEntities).mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }
    }
}

