/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import java.util.Map;

public class BuildTimeSettings {
    private RecordedConfig source;
    private Map<String, Object> quarkusConfigSettings;
    private Map<String, String> databaseOrmCompatibilitySettings;
    private Map<String, Object> allSettings;

    public BuildTimeSettings(RecordedConfig source, Map<String, Object> quarkusConfigSettings, Map<String, String> databaseOrmCompatibilitySettings, Map<String, Object> allSettings) {
        this.source = source;
        this.quarkusConfigSettings = Map.copyOf(quarkusConfigSettings);
        this.databaseOrmCompatibilitySettings = Map.copyOf(databaseOrmCompatibilitySettings);
        this.allSettings = Map.copyOf(allSettings);
    }

    public Object get(String key) {
        return this.allSettings.get(key);
    }

    public boolean getBoolean(String key) {
        Object propertyValue = this.allSettings.get(key);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    public boolean isConfigured(String key) {
        return this.allSettings.containsKey(key);
    }

    public RecordedConfig getSource() {
        return this.source;
    }

    public Map<String, Object> getQuarkusConfigSettings() {
        return this.quarkusConfigSettings;
    }

    public Map<String, String> getDatabaseOrmCompatibilitySettings() {
        return this.databaseOrmCompatibilitySettings;
    }

    public Map<String, Object> getAllSettings() {
        return this.allSettings;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.allSettings.toString() + "}";
    }
}

