/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot.scan;

import io.quarkus.commons.classloading.ClassloadHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.boot.archive.internal.UrlInputStreamAccess;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.spi.InputStreamAccess;

public class QuarkusScanner
implements Scanner {
    private Set<PackageDescriptor> packageDescriptors;
    private Set<ClassDescriptor> classDescriptors;

    public ScanResult scan(ScanEnvironment scanEnvironment, ScanOptions scanOptions, ScanParameters scanParameters) {
        return new Result(this.packageDescriptors, this.classDescriptors, scanEnvironment, scanOptions);
    }

    public Set<PackageDescriptor> getPackageDescriptors() {
        return this.packageDescriptors;
    }

    public void setPackageDescriptors(Set<PackageDescriptor> packageDescriptors) {
        this.packageDescriptors = packageDescriptors;
    }

    public Set<ClassDescriptor> getClassDescriptors() {
        return this.classDescriptors;
    }

    public void setClassDescriptors(Set<ClassDescriptor> classDescriptors) {
        this.classDescriptors = classDescriptors;
    }

    public static class Result
    implements ScanResult {
        private final Set<PackageDescriptor> selectedPackageDescriptors = new HashSet<PackageDescriptor>();
        private final Set<ClassDescriptor> selectedClassDescriptors = new HashSet<ClassDescriptor>();

        Result(Set<PackageDescriptor> packageDescriptors, Set<ClassDescriptor> classDescriptors, ScanEnvironment scanEnvironment, ScanOptions scanOptions) {
            for (PackageDescriptor packageDescriptor : packageDescriptors) {
                if (!scanOptions.canDetectUnlistedClassesInRoot() && !scanEnvironment.getExplicitlyListedClassNames().contains(packageDescriptor.getName())) continue;
                this.selectedPackageDescriptors.add(packageDescriptor);
            }
            for (ClassDescriptor classDescriptor : classDescriptors) {
                if (!scanOptions.canDetectUnlistedClassesInRoot() && !scanEnvironment.getExplicitlyListedClassNames().contains(classDescriptor.getName())) continue;
                this.selectedClassDescriptors.add(classDescriptor);
            }
        }

        public Set<PackageDescriptor> getLocatedPackages() {
            return this.selectedPackageDescriptors;
        }

        public Set<ClassDescriptor> getLocatedClasses() {
            return this.selectedClassDescriptors;
        }

        public Set<MappingFileDescriptor> getLocatedMappingFiles() {
            return Collections.emptySet();
        }
    }

    public static class ClassDescriptorImpl
    implements ClassDescriptor {
        private String name;
        private ClassDescriptor.Categorization categorization;

        public ClassDescriptorImpl(String name, ClassDescriptor.Categorization categorization) {
            this.name = name;
            this.categorization = categorization;
        }

        public ClassDescriptorImpl() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCategorization(ClassDescriptor.Categorization categorization) {
            this.categorization = categorization;
        }

        public String getName() {
            return this.name;
        }

        public ClassDescriptor.Categorization getCategorization() {
            return this.categorization;
        }

        public InputStreamAccess getStreamAccess() {
            String resourceName = ClassloadHelper.fromClassNameToResourceName((String)this.name);
            return new UrlInputStreamAccess(Thread.currentThread().getContextClassLoader().getResource(resourceName));
        }
    }

    public static class PackageDescriptorImpl
    implements PackageDescriptor {
        private String name;

        public PackageDescriptorImpl(String name) {
            this.name = name;
        }

        public PackageDescriptorImpl() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public InputStreamAccess getStreamAccess() {
            return new UrlInputStreamAccess(Thread.currentThread().getContextClassLoader().getResource(this.name.replace('.', '/') + "/package-info.class"));
        }
    }
}

