/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.ProviderUtil;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.boot.FastBootEntityManagerFactoryBuilder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.boot.registry.PreconfiguredServiceRegistryBuilder;
import io.quarkus.hibernate.orm.runtime.config.DatabaseOrmCompatibilityVersion;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.service.internal.ProvidedService;
import org.jboss.logging.Logger;

public final class FastBootHibernatePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(FastBootHibernatePersistenceProvider.class);
    private final ProviderUtil providerUtil = new ProviderUtil();
    private final HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig;
    private final Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors;

    public FastBootHibernatePersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        this.hibernateOrmRuntimeConfig = hibernateOrmRuntimeConfig;
        this.integrationRuntimeDescriptors = integrationRuntimeDescriptors;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        log.tracef("Starting createEntityManagerFactory for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning null");
            return null;
        }
        return builder.build();
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        log.tracef("Starting createContainerEntityManagerFactory : %s", (Object)info.getPersistenceUnitName());
        return this.getEntityManagerFactoryBuilder(info, properties).build();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        log.tracef("Starting generateSchema : PUI.name=%s", (Object)info.getPersistenceUnitName());
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder(info, map);
        builder.generateSchema();
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        log.tracef("Starting generateSchema for persistenceUnitName %s", (Object)persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, map);
        if (builder == null) {
            log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning false");
            return false;
        }
        builder.generateSchema();
        return true;
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }

    public EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map integration) {
        return this.getEntityManagerFactoryBuilder(info.getPersistenceUnitName(), integration);
    }

    public EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(String persistenceUnitName, Map integration) {
        return this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, integration);
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", (Object)persistenceUnitName);
        this.verifyProperties(properties);
        List<QuarkusPersistenceUnitDescriptor> units = PersistenceUnitsHolder.getPersistenceUnitDescriptors();
        log.debugf("Located %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (QuarkusPersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnit.getProviderClassName(), (Object)persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debugf("Excluding from consideration '%s' due to name mismatch", (Object)persistenceUnit.getName());
                continue;
            }
            if (!this.isProvider(persistenceUnit)) {
                log.debug((Object)"Excluding from consideration due to provider mismatch");
                continue;
            }
            RecordedState recordedState = PersistenceUnitsHolder.popRecordedState(persistenceUnitName);
            if (recordedState.isReactive()) {
                throw new IllegalStateException("Attempting to boot a blocking Hibernate ORM instance on a reactive RecordedState");
            }
            PrevalidatedQuarkusMetadata metadata = recordedState.getMetadata();
            HibernateOrmRuntimeConfigPersistenceUnit puConfig = this.hibernateOrmRuntimeConfig.persistenceUnits().get(persistenceUnit.getConfigurationName());
            if (puConfig.active().isPresent() && !puConfig.active().get().booleanValue()) {
                throw new IllegalStateException("Attempting to boot a deactivated Hibernate ORM persistence unit");
            }
            RuntimeSettings runtimeSettings = this.buildRuntimeSettings(persistenceUnitName, recordedState, puConfig);
            StandardServiceRegistry standardServiceRegistry = this.rewireMetadataAndExtractServiceRegistry(runtimeSettings, recordedState, persistenceUnitName);
            BeanManager cdiBeanManager = Arc.container().beanManager();
            Object validatorFactory = Arc.container().instance("quarkus-hibernate-validator-factory").get();
            return new FastBootEntityManagerFactoryBuilder(metadata, persistenceUnitName, standardServiceRegistry, runtimeSettings, validatorFactory, cdiBeanManager, recordedState.getMultiTenancyStrategy());
        }
        log.debug((Object)"Found no matching persistence units");
        return null;
    }

    private RuntimeSettings buildRuntimeSettings(String persistenceUnitName, RecordedState recordedState, HibernateOrmRuntimeConfigPersistenceUnit persistenceUnitConfig) {
        BuildTimeSettings buildTimeSettings = recordedState.getBuildTimeSettings();
        IntegrationSettings integrationSettings = recordedState.getIntegrationSettings();
        RuntimeSettings.Builder runtimeSettingsBuilder = new RuntimeSettings.Builder(buildTimeSettings, integrationSettings);
        Optional<String> dataSourceName = recordedState.getBuildTimeSettings().getSource().getDataSource();
        if (dataSourceName.isPresent()) {
            FastBootHibernatePersistenceProvider.injectDataSource(persistenceUnitName, dataSourceName.get(), runtimeSettingsBuilder);
        }
        if (!recordedState.isFromPersistenceXml()) {
            FastBootHibernatePersistenceProvider.injectRuntimeConfiguration(persistenceUnitConfig, runtimeSettingsBuilder);
        }
        for (HibernateOrmIntegrationRuntimeDescriptor hibernateOrmIntegrationRuntimeDescriptor : this.integrationRuntimeDescriptors.getOrDefault(persistenceUnitName, Collections.emptyList())) {
            Optional<HibernateOrmIntegrationRuntimeInitListener> listenerOptional = hibernateOrmIntegrationRuntimeDescriptor.getInitListener();
            if (!listenerOptional.isPresent()) continue;
            listenerOptional.get().contributeRuntimeProperties(runtimeSettingsBuilder::put);
        }
        runtimeSettingsBuilder.put("hibernate.boot.allow_jdbc_metadata_access", "true");
        if (!persistenceUnitConfig.unsupportedProperties().isEmpty()) {
            log.warnf("Persistence-unit [%s] sets unsupported properties. These properties may not work correctly, and even if they do, that may change when upgrading to a newer version of Quarkus (even just a micro/patch version). Consider using a supported configuration property before falling back to unsupported ones. If there is no supported equivalent, make sure to file a feature request so that a supported configuration property can be added to Quarkus, and more importantly so that the configuration property is tested regularly. Unsupported properties being set: %s", (Object)persistenceUnitName, persistenceUnitConfig.unsupportedProperties().keySet());
        }
        for (Map.Entry entry : persistenceUnitConfig.unsupportedProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (runtimeSettingsBuilder.get(key) != null) {
                log.warnf("Persistence-unit [%s] sets property '%s' to a custom value through '%s', but Quarkus already set that property independently. The custom value will be ignored.", (Object)persistenceUnitName, (Object)key, (Object)HibernateOrmRuntimeConfig.puPropertyKey(persistenceUnitName, "unsupported-properties.\"" + key + "\""));
                continue;
            }
            runtimeSettingsBuilder.put((String)entry.getKey(), entry.getValue());
        }
        DatabaseOrmCompatibilityVersion databaseOrmCompatibilityVersion = buildTimeSettings.getSource().getDatabaseOrmCompatibilityVersion();
        Map<String, String> map = buildTimeSettings.getDatabaseOrmCompatibilitySettings();
        if (databaseOrmCompatibilityVersion != DatabaseOrmCompatibilityVersion.LATEST) {
            log.warnf("Persistence-unit [%1$s]: enabling best-effort backwards compatibility with '%2$s=%3$s'. Quarkus will attempt to change the behavior and expected schema of Hibernate ORM to match those of Hibernate ORM %3$s. This is an inherently best-effort feature that cannot address all  backwards-incompatible changes of Hibernate ORM 6. It is also inherently unstable and may stop working in future versions of Quarkus. Consider migrating your application to native Hibernate ORM 6 behavior; see https://github.com/quarkusio/quarkus/wiki/Migration-Guide-3.0:-Hibernate-ORM-5-to-6-migration for more information.", new Object[]{persistenceUnitName, HibernateOrmRuntimeConfig.puPropertyKey(persistenceUnitName, "database.orm-compatibility.version"), databaseOrmCompatibilityVersion.externalRepresentation, persistenceUnitConfig.unsupportedProperties().keySet()});
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (runtimeSettingsBuilder.isConfigured(key)) continue;
            log.warnf("Persistence-unit [%1$s] - %2$s compatibility: setting '%3$s=%4$s'. This affects Hibernate ORM's behavior and schema compatibility and may stop working in future versions of Quarkus.", new Object[]{persistenceUnitName, databaseOrmCompatibilityVersion.externalRepresentation, key, value});
            runtimeSettingsBuilder.put(key, value);
        }
        return runtimeSettingsBuilder.build();
    }

    private StandardServiceRegistry rewireMetadataAndExtractServiceRegistry(RuntimeSettings runtimeSettings, RecordedState rs, String persistenceUnitName) {
        PreconfiguredServiceRegistryBuilder serviceRegistryBuilder = new PreconfiguredServiceRegistryBuilder(persistenceUnitName, rs);
        runtimeSettings.getSettings().forEach((key, value) -> serviceRegistryBuilder.applySetting((String)key, value));
        HashSet<Class> runtimeInitiatedServiceClasses = new HashSet<Class>();
        for (HibernateOrmIntegrationRuntimeDescriptor hibernateOrmIntegrationRuntimeDescriptor : this.integrationRuntimeDescriptors.getOrDefault(persistenceUnitName, Collections.emptyList())) {
            Optional<HibernateOrmIntegrationRuntimeInitListener> listenerOptional = hibernateOrmIntegrationRuntimeDescriptor.getInitListener();
            if (!listenerOptional.isPresent()) continue;
            for (StandardServiceInitiator<?> serviceInitiator : listenerOptional.get().contributeServiceInitiators()) {
                Class serviceClass = serviceInitiator.getServiceInitiated();
                runtimeInitiatedServiceClasses.add(serviceClass);
                serviceRegistryBuilder.addInitiator(serviceInitiator);
            }
        }
        for (ProvidedService providedService : rs.getProvidedServices()) {
            if (runtimeInitiatedServiceClasses.contains(providedService.getServiceRole())) continue;
            serviceRegistryBuilder.addService(providedService);
        }
        StandardServiceRegistryImpl standardServiceRegistry = serviceRegistryBuilder.buildNewServiceRegistry();
        return standardServiceRegistry;
    }

    private boolean isProvider(PersistenceUnitDescriptor persistenceUnit) {
        Map props = Collections.emptyMap();
        String requestedProviderName = FastBootHibernatePersistenceProvider.extractRequestedProviderName(persistenceUnit, props);
        if (requestedProviderName == null) {
            return true;
        }
        return FastBootHibernatePersistenceProvider.class.getName().equals(requestedProviderName) || "org.hibernate.jpa.HibernatePersistenceProvider".equals(requestedProviderName);
    }

    public static String extractRequestedProviderName(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        String integrationProviderName = FastBootHibernatePersistenceProvider.extractProviderName(integration);
        if (integrationProviderName != null) {
            log.debugf("Integration provided explicit PersistenceProvider [%s]", (Object)integrationProviderName);
            return integrationProviderName;
        }
        String persistenceUnitRequestedProvider = FastBootHibernatePersistenceProvider.extractProviderName(persistenceUnit);
        if (persistenceUnitRequestedProvider != null) {
            log.debugf("Persistence-unit [%s] requested PersistenceProvider [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnitRequestedProvider);
            return persistenceUnitRequestedProvider;
        }
        log.debug((Object)"No PersistenceProvider explicitly requested, assuming Hibernate");
        return FastBootHibernatePersistenceProvider.class.getName();
    }

    private static String extractProviderName(Map integration) {
        if (integration == null) {
            return null;
        }
        String setting = (String)integration.get("jakarta.persistence.provider");
        return setting == null ? null : setting.trim();
    }

    private static String extractProviderName(PersistenceUnitDescriptor persistenceUnit) {
        String persistenceUnitRequestedProvider = persistenceUnit.getProviderClassName();
        return persistenceUnitRequestedProvider == null ? null : persistenceUnitRequestedProvider.trim();
    }

    private void verifyProperties(Map properties) {
        if (properties != null && properties.size() != 0) {
            throw new PersistenceException("The FastbootHibernateProvider PersistenceProvider can not support runtime provided properties. Make sure you set all properties you need in the configuration resources before building the application.");
        }
    }

    private static void injectDataSource(String persistenceUnitName, String dataSourceName, RuntimeSettings.Builder runtimeSettingsBuilder) {
        AgroalDataSource dataSource;
        if (runtimeSettingsBuilder.isConfigured("hibernate.connection.url") || runtimeSettingsBuilder.isConfigured("hibernate.connection.datasource") || runtimeSettingsBuilder.isConfigured("javax.persistence.jtaDataSource") || runtimeSettingsBuilder.isConfigured("javax.persistence.nonJtaDataSource") || runtimeSettingsBuilder.isConfigured("jakarta.persistence.jtaDataSource") || runtimeSettingsBuilder.isConfigured("jakarta.persistence.nonJtaDataSource")) {
            return;
        }
        try {
            dataSource = ((DataSources)Arc.container().instance(DataSources.class, new Annotation[0]).get()).getDataSource(dataSourceName);
            if (dataSource instanceof UnconfiguredDataSource) {
                throw DataSourceUtil.dataSourceNotConfigured((String)dataSourceName);
            }
        }
        catch (RuntimeException e) {
            throw PersistenceUnitUtil.unableToFindDataSource(persistenceUnitName, dataSourceName, e);
        }
        runtimeSettingsBuilder.put("hibernate.connection.datasource", dataSource);
    }

    private static void injectRuntimeConfiguration(HibernateOrmRuntimeConfigPersistenceUnit persistenceUnitConfig, RuntimeSettings.Builder runtimeSettingsBuilder) {
        runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.database.action", persistenceUnitConfig.database().generation().generation());
        runtimeSettingsBuilder.put("jakarta.persistence.create-database-schemas", String.valueOf(persistenceUnitConfig.database().generation().createSchemas()));
        if (persistenceUnitConfig.database().generation().haltOnError()) {
            runtimeSettingsBuilder.put("hibernate.hbm2ddl.halt_on_error", "true");
        }
        runtimeSettingsBuilder.put("hibernate.hbm2ddl.schema-generation.script.append", "false");
        runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.scripts.action", persistenceUnitConfig.scripts().generation().generation());
        if (persistenceUnitConfig.scripts().generation().createTarget().isPresent()) {
            runtimeSettingsBuilder.put("javax.persistence.schema-generation.scripts.create-target", persistenceUnitConfig.scripts().generation().createTarget().get());
        }
        if (persistenceUnitConfig.scripts().generation().dropTarget().isPresent()) {
            runtimeSettingsBuilder.put("javax.persistence.schema-generation.scripts.drop-target", persistenceUnitConfig.scripts().generation().dropTarget().get());
        }
        persistenceUnitConfig.database().defaultCatalog().ifPresent(catalog -> runtimeSettingsBuilder.put("hibernate.default_catalog", catalog));
        persistenceUnitConfig.database().defaultSchema().ifPresent(schema -> runtimeSettingsBuilder.put("hibernate.default_schema", schema));
        if (persistenceUnitConfig.log().sql()) {
            runtimeSettingsBuilder.put("hibernate.show_sql", "true");
            if (persistenceUnitConfig.log().formatSql()) {
                runtimeSettingsBuilder.put("hibernate.format_sql", "true");
            }
            if (persistenceUnitConfig.log().highlightSql()) {
                runtimeSettingsBuilder.put("hibernate.highlight_sql", "true");
            }
        }
        if (persistenceUnitConfig.log().jdbcWarnings().isPresent()) {
            runtimeSettingsBuilder.put("hibernate.jdbc.log.warnings", persistenceUnitConfig.log().jdbcWarnings().get().toString());
        }
        if (persistenceUnitConfig.log().queriesSlowerThanMs().isPresent()) {
            runtimeSettingsBuilder.put("hibernate.log_slow_query", persistenceUnitConfig.log().queriesSlowerThanMs().get());
        }
        runtimeSettingsBuilder.put("org.hibernate.flushMode", persistenceUnitConfig.flush().mode());
    }
}

