/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.session;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedStatelessSessionHolder;
import io.quarkus.hibernate.orm.runtime.session.JTAStatelessSessionOpener;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Instance;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.List;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaInsert;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;

public class TransactionScopedStatelessSession
implements StatelessSession {
    protected static final String TRANSACTION_IS_NOT_ACTIVE = "Transaction is not active, consider adding @Transactional to your method to automatically activate one.";
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final SessionFactory sessionFactory;
    private final JTAStatelessSessionOpener jtaSessionOpener;
    private final String unitName;
    private final String sessionKey;
    private final boolean requestScopedSessionEnabled;
    private final Instance<RequestScopedStatelessSessionHolder> requestScopedSessions;

    public TransactionScopedStatelessSession(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, SessionFactory sessionFactory, String unitName, boolean requestScopedSessionEnabled, Instance<RequestScopedStatelessSessionHolder> requestScopedSessions) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.sessionFactory = sessionFactory;
        this.jtaSessionOpener = JTAStatelessSessionOpener.create(sessionFactory);
        this.unitName = unitName;
        this.sessionKey = this.getClass().getSimpleName() + "-" + unitName;
        this.requestScopedSessionEnabled = requestScopedSessionEnabled;
        this.requestScopedSessions = requestScopedSessions;
    }

    SessionResult acquireSession() {
        if (this.isInTransaction()) {
            StatelessSession session = (StatelessSession)this.transactionSynchronizationRegistry.getResource((Object)this.sessionKey);
            if (session != null) {
                return new SessionResult(session, false, true);
            }
            StatelessSession newSession = this.jtaSessionOpener.openSession();
            this.transactionSynchronizationRegistry.putResource((Object)this.sessionKey, (Object)newSession);
            return new SessionResult(newSession, false, true);
        }
        if (this.requestScopedSessionEnabled) {
            if (Arc.container().requestContext().isActive()) {
                RequestScopedStatelessSessionHolder requestScopedSessions = (RequestScopedStatelessSessionHolder)this.requestScopedSessions.get();
                return new SessionResult(requestScopedSessions.getOrCreateSession(this.unitName, this.sessionFactory), false, false);
            }
            throw new ContextNotActiveException("Cannot use the StatelessSession because neither a transaction nor a CDI request context is active. Consider adding @Transactional to your method to automatically activate a transaction, or @ActivateRequestContext if you have valid reasons not to use transactions.");
        }
        throw new ContextNotActiveException("Cannot use the StatelessSession because no transaction is active. Consider adding @Transactional to your method to automatically activate a transaction, or set '" + HibernateOrmRuntimeConfig.extensionPropertyKey("request-scoped.enabled") + "' to 'true' if you have valid reasons not to use transactions.");
    }

    private void checkBlocking() {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new BlockingOperationNotAllowedException("You have attempted to perform a blocking operation on a IO thread. This is not allowed, as blocking the IO thread will cause major performance issues with your application. If you want to perform blocking StatelessSession operations make sure you are doing it from a worker thread.");
        }
    }

    private boolean isInTransaction() {
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void refresh(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.statelessSession.refresh(entity);
        }
    }

    @Deprecated
    public Query createQuery(String qlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createQuery(qlString);
            return query;
        }
    }

    public <T> Query<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createQuery(criteriaQuery);
            return query;
        }
    }

    @Deprecated
    public Query createQuery(CriteriaUpdate updateQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createQuery(updateQuery);
            return query;
        }
    }

    @Deprecated
    public Query createQuery(CriteriaDelete deleteQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createQuery(deleteQuery);
            return query;
        }
    }

    public <T> Query<T> createQuery(String qlString, Class<T> resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createQuery(qlString, resultClass);
            return query;
        }
    }

    @Deprecated
    public Query createNamedQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createNamedQuery(name);
            return query;
        }
    }

    public <T> Query<T> createNamedQuery(String name, Class<T> resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.createNamedQuery(name, resultClass);
            return query;
        }
    }

    @Deprecated
    public NativeQuery createNativeQuery(String sqlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.createNativeQuery(sqlString);
            return nativeQuery;
        }
    }

    @Deprecated
    public NativeQuery createNativeQuery(String sqlString, Class resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.createNativeQuery(sqlString, resultClass);
            return nativeQuery;
        }
    }

    @Deprecated
    public NativeQuery createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.createNativeQuery(sqlString, resultSetMapping);
            return nativeQuery;
        }
    }

    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createNamedStoredProcedureQuery(name);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureQuery(procedureName);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureQuery(procedureName, resultClasses);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureQuery(procedureName, resultSetMappings);
            return procedureCall;
        }
    }

    public void joinTransaction() {
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.joinTransaction();
        }
    }

    public boolean isJoinedToTransaction() {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.statelessSession.isJoinedToTransaction();
            return bl;
        }
    }

    public void close() {
        throw new IllegalStateException("Not supported for transaction scoped entity managers");
    }

    public Object insert(Object o) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.insert(o);
            return object;
        }
    }

    public Object insert(String s, Object o) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.insert(s, o);
            return object;
        }
    }

    public boolean isOpen() {
        return true;
    }

    public Transaction getTransaction() {
        throw new IllegalStateException("Not supported for JTA entity managers");
    }

    public HibernateCriteriaBuilder getCriteriaBuilder() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            HibernateCriteriaBuilder hibernateCriteriaBuilder = emr.statelessSession.getCriteriaBuilder();
            return hibernateCriteriaBuilder;
        }
    }

    @Deprecated
    public void update(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.update(object);
        }
    }

    @Deprecated
    public void update(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.update(entityName, object);
        }
    }

    @Deprecated
    public void delete(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.delete(object);
        }
    }

    @Deprecated
    public void delete(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.delete(entityName, object);
        }
    }

    @Deprecated
    public void refresh(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.refresh(entityName, object);
        }
    }

    public void refresh(Object object, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.refresh(object, lockMode);
        }
    }

    public void refresh(String s, Object o, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.refresh(s, o, lockMode);
        }
    }

    public void fetch(Object o) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.fetch(o);
        }
    }

    public Object getIdentifier(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.getIdentifier(entity);
            return object;
        }
    }

    public <T> T get(Class<T> entityType, Object id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(entityType, id);
            return (T)object;
        }
    }

    public <T> T get(Class<T> entityType, Object id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(entityType, id, lockMode);
            return (T)object;
        }
    }

    public Object get(String entityName, Object id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(entityName, id);
            return object;
        }
    }

    public Object get(String entityName, Object id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(entityName, id, lockMode);
            return object;
        }
    }

    public Filter enableFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Filter filter = emr.statelessSession.enableFilter(filterName);
            return filter;
        }
    }

    public Filter getEnabledFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Filter filter = emr.statelessSession.getEnabledFilter(filterName);
            return filter;
        }
    }

    public void disableFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.disableFilter(filterName);
        }
    }

    public String getTenantIdentifier() {
        try (SessionResult emr = this.acquireSession();){
            String string = emr.statelessSession.getTenantIdentifier();
            return string;
        }
    }

    public Object getTenantIdentifierValue() {
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.getTenantIdentifierValue();
            return object;
        }
    }

    public boolean isConnected() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.statelessSession.isConnected();
            return bl;
        }
    }

    public Transaction beginTransaction() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Transaction transaction = emr.statelessSession.beginTransaction();
            return transaction;
        }
    }

    @Deprecated
    public Query getNamedQuery(String queryName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.statelessSession.getNamedQuery(queryName);
            return query;
        }
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.getNamedProcedureCall(name);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureCall(procedureName);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureCall(procedureName, resultClasses);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.statelessSession.createStoredProcedureCall(procedureName, resultSetMappings);
            return procedureCall;
        }
    }

    public Integer getJdbcBatchSize() {
        try (SessionResult emr = this.acquireSession();){
            Integer n = emr.statelessSession.getJdbcBatchSize();
            return n;
        }
    }

    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.setJdbcBatchSize(jdbcBatchSize);
        }
    }

    public void doWork(Work work) throws HibernateException {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.doWork(work);
        }
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.doReturningWork(work);
            return (T)object;
        }
    }

    @Deprecated
    public NativeQuery getNamedNativeQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.getNamedNativeQuery(name);
            return nativeQuery;
        }
    }

    public <R> NativeQuery<R> createNativeQuery(String sqlString, Class<R> resultClass, String tableAlias) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.createNativeQuery(sqlString, resultClass, tableAlias);
            return nativeQuery;
        }
    }

    public <R> NativeQuery<R> createNativeQuery(String sqlString, String resultSetMappingName, Class<R> resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.createNativeQuery(sqlString, resultSetMappingName, resultClass);
            return nativeQuery;
        }
    }

    public SelectionQuery<?> createSelectionQuery(String hqlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SelectionQuery selectionQuery = emr.statelessSession.createSelectionQuery(hqlString);
            return selectionQuery;
        }
    }

    public <R> SelectionQuery<R> createSelectionQuery(String hqlString, Class<R> resultType) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SelectionQuery selectionQuery = emr.statelessSession.createSelectionQuery(hqlString, resultType);
            return selectionQuery;
        }
    }

    public <R> SelectionQuery<R> createSelectionQuery(CriteriaQuery<R> criteria) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SelectionQuery selectionQuery = emr.statelessSession.createSelectionQuery(criteria);
            return selectionQuery;
        }
    }

    public MutationQuery createMutationQuery(String hqlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createMutationQuery(hqlString);
            return mutationQuery;
        }
    }

    public MutationQuery createMutationQuery(CriteriaUpdate updateQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createMutationQuery(updateQuery);
            return mutationQuery;
        }
    }

    public MutationQuery createMutationQuery(CriteriaDelete deleteQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createMutationQuery(deleteQuery);
            return mutationQuery;
        }
    }

    public MutationQuery createMutationQuery(JpaCriteriaInsertSelect insertSelect) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createMutationQuery(insertSelect);
            return mutationQuery;
        }
    }

    public MutationQuery createMutationQuery(JpaCriteriaInsert insertSelect) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createMutationQuery(insertSelect);
            return mutationQuery;
        }
    }

    public MutationQuery createNativeMutationQuery(String sqlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createNativeMutationQuery(sqlString);
            return mutationQuery;
        }
    }

    public SelectionQuery<?> createNamedSelectionQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SelectionQuery selectionQuery = emr.statelessSession.createNamedSelectionQuery(name);
            return selectionQuery;
        }
    }

    public <R> SelectionQuery<R> createNamedSelectionQuery(String name, Class<R> resultType) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SelectionQuery selectionQuery = emr.statelessSession.createNamedSelectionQuery(name, resultType);
            return selectionQuery;
        }
    }

    public MutationQuery createNamedMutationQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MutationQuery mutationQuery = emr.statelessSession.createNamedMutationQuery(name);
            return mutationQuery;
        }
    }

    @Deprecated
    public NativeQuery getNamedNativeQuery(String name, String resultSetMapping) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.statelessSession.getNamedNativeQuery(name, resultSetMapping);
            return nativeQuery;
        }
    }

    public <T> RootGraph<T> createEntityGraph(Class<T> rootType) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.statelessSession.createEntityGraph(rootType);
            return rootGraph;
        }
    }

    public RootGraph<?> createEntityGraph(String graphName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.statelessSession.createEntityGraph(graphName);
            return rootGraph;
        }
    }

    public <T> RootGraph<T> createEntityGraph(Class<T> rootType, String graphName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.statelessSession.createEntityGraph(rootType, graphName);
            return rootGraph;
        }
    }

    public RootGraph<?> getEntityGraph(String graphName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.statelessSession.getEntityGraph(graphName);
            return rootGraph;
        }
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            List list = emr.statelessSession.getEntityGraphs(entityClass);
            return list;
        }
    }

    public SessionFactory getFactory() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SessionFactory sessionFactory = emr.statelessSession.getFactory();
            return sessionFactory;
        }
    }

    public void upsert(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.upsert(entity);
        }
    }

    public void upsert(String entityName, Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.statelessSession.upsert(entityName, entity);
        }
    }

    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(graph, graphSemantic, id);
            return (T)object;
        }
    }

    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.statelessSession.get(graph, graphSemantic, id, lockMode);
            return (T)object;
        }
    }

    static class SessionResult
    implements AutoCloseable {
        final StatelessSession statelessSession;
        final boolean closeOnEnd;
        final boolean allowModification;

        SessionResult(StatelessSession statelessSession, boolean closeOnEnd, boolean allowModification) {
            this.statelessSession = statelessSession;
            this.closeOnEnd = closeOnEnd;
            this.allowModification = allowModification;
        }

        @Override
        public void close() {
            if (this.closeOnEnd) {
                this.statelessSession.close();
            }
        }
    }
}

