/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.type.MappingContext;
import org.jboss.logging.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuiltinFormatMapperBehaviour {
    IGNORE{

        @Override
        protected void action(String puName, String type) {
        }
    }
    ,
    WARN{

        @Override
        protected void action(String puName, String type) {
            LOGGER.warn((Object)BuiltinFormatMapperBehaviour.message(puName, type));
        }
    }
    ,
    FAIL{

        @Override
        protected void action(String puName, String type) {
            throw new IllegalStateException(BuiltinFormatMapperBehaviour.message(puName, type));
        }
    };

    private static final Logger LOGGER;
    private static final String TYPE_JSON = "JSON";
    private static final String TYPE_XML = "XML";

    private static String message(String puName, String type) {
        return String.format(Locale.ROOT, "Persistence unit [%1$s] uses Quarkus' main formatting facilities for %2$s columns in the database. \nAs these facilities are primarily meant for REST endpoints, and they might have been customized for such use, this may lead to undesired behavior, up to and including data loss. \nTo address this:\n\t- If the application does not customize the %2$s serialization/deserialization, set \"quarkus.hibernate-orm.mapping.format.global=ignore\". This will be the default in future versions of Quarkus. \n\t- Otherwise, define a custom `FormatMapper` bean annotated with " + (TYPE_JSON.equals(type) ? "@JsonFormat" : "@XmlFormat") + " and @PersistenceUnitExtension" + (PersistenceUnitUtil.isDefaultPersistenceUnit(puName) ? "" : "(\"%1$s\")") + "to address your database serialization/deserialization needs.\nSee the migration guide for more details and how to proceed.", puName, type);
    }

    public static boolean hasJsonProperties(MetadataImplementor metadata) {
        return BuiltinFormatMapperBehaviour.hasXxxProperties(metadata, Set.of(Integer.valueOf(3001), Integer.valueOf(3018)));
    }

    public static boolean hasXmlProperties(MetadataImplementor metadata) {
        return BuiltinFormatMapperBehaviour.hasXxxProperties(metadata, Set.of(Integer.valueOf(2009), Integer.valueOf(3019)));
    }

    private static boolean hasXxxProperties(MetadataImplementor metadata, Set<Integer> sqlTypeCodes) {
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            for (Property property : persistentClass.getProperties()) {
                Value value;
                List columns = property.getColumns();
                if (columns.isEmpty() && (value = property.getValue()) instanceof Collection) {
                    Collection c = (Collection)value;
                    columns = c.getElement().getColumns();
                }
                for (Column column : columns) {
                    if (!sqlTypeCodes.contains(column.getSqlTypeCode((MappingContext)metadata))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void jsonApply(MetadataImplementor metadata, String puName) {
        if (BuiltinFormatMapperBehaviour.hasJsonProperties(metadata)) {
            this.action(puName, TYPE_JSON);
        }
    }

    public void xmlApply(MetadataImplementor metadata, String puName) {
        if (BuiltinFormatMapperBehaviour.hasXmlProperties(metadata)) {
            this.action(puName, TYPE_XML);
        }
    }

    protected abstract void action(String var1, String var2);

    static {
        LOGGER = Logger.getLogger(BuiltinFormatMapperBehaviour.class);
    }
}

