/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.proxies;

import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;

public final class ProxyDefinitions {
    private final Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap;

    private ProxyDefinitions(Map<Class<?>, ProxyClassDetailsHolder> proxyDefinitionMap) {
        this.proxyDefinitionMap = proxyDefinitionMap;
    }

    public static ProxyDefinitions createFromMetadata(Metadata storeableMetadata, PreGeneratedProxies preGeneratedProxies) {
        if (ProxyDefinitions.needAnyProxyDefinitions(storeableMetadata)) {
            HashMap proxyDefinitionMap = new HashMap();
            for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
                if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
                Class mappedClass = persistentClass.getMappedClass();
                Class<?> proxyClassDefinition = ProxyDefinitions.getProxyClass(persistentClass, preGeneratedProxies);
                if (proxyClassDefinition == null) continue;
                boolean overridesEquals = ReflectHelper.overridesEquals((Class)mappedClass);
                try {
                    proxyDefinitionMap.put(mappedClass, new ProxyClassDetailsHolder(overridesEquals, proxyClassDefinition.getConstructor(new Class[0])));
                }
                catch (NoSuchMethodException e) {
                    throw new HibernateException("Failed to generate Enhanced Proxy: default constructor is missing for entity '" + mappedClass.getName() + "'. Please add a default constructor explicitly.");
                }
            }
            return new ProxyDefinitions(proxyDefinitionMap);
        }
        return new ProxyDefinitions(Collections.emptyMap());
    }

    private static boolean needAnyProxyDefinitions(Metadata storeableMetadata) {
        for (PersistentClass persistentClass : storeableMetadata.getEntityBindings()) {
            if (!ProxyDefinitions.needsProxyGeneration(persistentClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsProxyGeneration(PersistentClass persistentClass) {
        return persistentClass.isLazy() && persistentClass.getMappedClass() != null;
    }

    private static Class<?> getProxyClass(PersistentClass persistentClass, PreGeneratedProxies preGeneratedProxies) {
        PreGeneratedProxies.ProxyClassDetailsHolder preProxy = preGeneratedProxies.getProxies().get(persistentClass.getClassName());
        if (preProxy == null) {
            return null;
        }
        try {
            return Class.forName(preProxy.getClassName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load proxy class", e);
        }
    }

    private static Class[] toArray(Set<Class<?>> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public ProxyClassDetailsHolder getProxyForClass(Class persistentClass) {
        return this.proxyDefinitionMap.get(persistentClass);
    }

    public static class ProxyClassDetailsHolder {
        private final boolean overridesEquals;
        private final Constructor constructor;

        private ProxyClassDetailsHolder(boolean overridesEquals, Constructor constructor) {
            this.overridesEquals = overridesEquals;
            this.constructor = constructor;
        }

        public boolean isOverridesEquals() {
            return this.overridesEquals;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }
    }
}

