/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.NonJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import io.quarkus.hibernate.reactive.runtime.ReactiveSessionFactoryProducer;
import io.quarkus.hibernate.reactive.runtime.ReactiveSessionProducer;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;

public final class HibernateReactiveProcessor {
    private static final String HIBERNATE_REACTIVE = "Hibernate Reactive";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.HIBERNATE_REACTIVE);
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.HIBERNATE_REACTIVE);
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        if (descriptors.size() == 1) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveSessionFactoryProducer.class}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveSessionProducer.class}));
        }
    }

    @BuildStep
    void reflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] classes = new String[]{"org.hibernate.reactive.persister.entity.impl.ReactiveSingleTableEntityPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveOneToManyPersister"};
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateReactiveRecorder recorder, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        boolean enableRx = this.hasEntities(jpaEntities, nonJpaModels);
        recorder.callHibernateReactiveFeatureInit(enableRx);
    }

    @BuildStep
    public void buildReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaEntitiesBuildItem domainObjects, List<NonJpaModelBuildItem> nonJpaModelBuildItems, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors) {
        boolean enableHR = this.hasEntities(domainObjects, nonJpaModelBuildItems);
        if (!enableHR) {
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            String provider = persistenceXmlDescriptorBuildItem.getDescriptor().getProviderClassName();
            if (provider != null && !provider.equals(FastBootHibernateReactivePersistenceProvider.class.getCanonicalName()) && !provider.equals("org.hibernate.reactive.provider.ReactivePersistenceProvider")) continue;
            throw new ConfigurationError("Cannot use persistence.xml with Hibernate Reactive in Quarkus. Must use application.properties instead.");
        }
        Optional dbKindOptional = dataSourcesBuildTimeConfig.defaultDataSource.dbKind;
        if (dbKindOptional.isPresent()) {
            String dbKind = (String)dbKindOptional.get();
            ParsedPersistenceXmlDescriptor reactivePU = HibernateReactiveProcessor.generateReactivePersistenceUnit(hibernateOrmConfig, domainObjects, dbKind, applicationArchivesBuildItem, launchMode.getLaunchMode(), systemProperties, nativeImageResources, hotDeploymentWatchedFiles);
            persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(reactivePU, true, false));
        }
    }

    @BuildStep
    void waitForVertxPool(List<VertxPoolBuildItem> vertxPool, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_REACTIVE, puDescriptor.getPersistenceUnitName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    PersistenceProviderSetUpBuildItem setUpPersistenceProviderAndWaitForVertxPool(HibernateReactiveRecorder recorder, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems) {
        recorder.initializePersistenceProvider(hibernateOrmRuntimeConfig, HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        return new PersistenceProviderSetUpBuildItem();
    }

    private static ParsedPersistenceXmlDescriptor generateReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, JpaEntitiesBuildItem domainObjects, String dbKind, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        Properties p;
        Optional<String> importFile;
        HibernateOrmConfigPersistenceUnit persistenceUnitConfig = hibernateOrmConfig.defaultPersistenceUnit;
        Optional dialect = persistenceUnitConfig.dialect.dialect;
        if (!dialect.isPresent()) {
            dialect = HibernateOrmProcessor.guessDialect((String)dbKind);
        }
        String dialectClassName = (String)dialect.get();
        ParsedPersistenceXmlDescriptor desc = new ParsedPersistenceXmlDescriptor(null);
        desc.setName("default-reactive");
        desc.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        desc.getProperties().setProperty("hibernate.dialect", dialectClassName);
        desc.setExcludeUnlistedClasses(true);
        desc.addClasses(new ArrayList(domainObjects.getAllModelClassNames()));
        if (persistenceUnitConfig.dialect.storageEngine.isPresent()) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", (String)persistenceUnitConfig.dialect.storageEngine.get()));
        }
        persistenceUnitConfig.physicalNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        persistenceUnitConfig.implicitNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", persistenceUnitConfig.database.charset.name());
        persistenceUnitConfig.database.defaultCatalog.ifPresent(catalog -> desc.getProperties().setProperty("hibernate.default_catalog", (String)catalog));
        persistenceUnitConfig.database.defaultSchema.ifPresent(schema -> desc.getProperties().setProperty("hibernate.default_schema", (String)schema));
        if (persistenceUnitConfig.database.globallyQuotedIdentifiers) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (persistenceUnitConfig.batchFetchSize > 0) {
            desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(persistenceUnitConfig.batchFetchSize));
            desc.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
        }
        persistenceUnitConfig.maxFetchDepth.ifPresent(depth -> desc.getProperties().setProperty("hibernate.max_fetch_depth", String.valueOf(depth)));
        desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", Integer.toString(persistenceUnitConfig.query.queryPlanCacheMaxSize));
        desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", persistenceUnitConfig.query.defaultNullOrdering.name().toLowerCase());
        if (hibernateOrmConfig.metricsEnabled || hibernateOrmConfig.statistics.isPresent() && ((Boolean)hibernateOrmConfig.statistics.get()).booleanValue()) {
            desc.getProperties().setProperty("hibernate.generate_statistics", "true");
        }
        if ((importFile = HibernateReactiveProcessor.getSqlLoadScript(persistenceUnitConfig.sqlLoadScript, launchMode)).isPresent()) {
            Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile.get());
            if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile.get()}));
                hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile.get()));
                desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", importFile.get());
            } else if (persistenceUnitConfig.sqlLoadScript.isPresent()) {
                throw new ConfigurationError("Unable to find file referenced in 'quarkus.hibernate-orm.sql-load-script=" + (String)persistenceUnitConfig.sqlLoadScript.get() + "'. Remove property or add file to your path.");
            }
        } else {
            desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", "");
        }
        if (persistenceUnitConfig.secondLevelCachingEnabled) {
            p = desc.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("javax.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries((HibernateOrmConfigPersistenceUnit)persistenceUnitConfig);
            for (Map.Entry entry : cacheConfigEntries.entrySet()) {
                desc.getProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            p = desc.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("javax.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
        return desc;
    }

    private static Optional<String> getSqlLoadScript(Optional<String> sqlLoadScript, LaunchMode launchMode) {
        if (sqlLoadScript.isPresent()) {
            if ("no-file".equalsIgnoreCase(sqlLoadScript.get())) {
                return Optional.empty();
            }
            return Optional.of(sqlLoadScript.get());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Optional.empty();
        }
        return Optional.of("import.sql");
    }

    private boolean hasEntities(JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        return !jpaEntities.getEntityClassNames().isEmpty() || !nonJpaModels.isEmpty();
    }
}

