/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.NonJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import io.quarkus.hibernate.reactive.runtime.ReactiveSessionFactoryProducer;
import io.quarkus.hibernate.reactive.runtime.ReactiveSessionProducer;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.tool.hbm2ddl.MultipleLinesSqlCommandExtractor;

public final class HibernateReactiveProcessor {
    private static final String HIBERNATE_REACTIVE = "Hibernate Reactive";
    HibernateOrmConfig hibernateConfig;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.HIBERNATE_REACTIVE);
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.HIBERNATE_REACTIVE);
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ReactiveSessionFactoryProducer.class).addBeanClass(ReactiveSessionProducer.class).build());
    }

    @BuildStep
    void reflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] classes = new String[]{"org.hibernate.reactive.persister.entity.impl.ReactiveSingleTableEntityPersister"};
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateReactiveRecorder recorder, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        boolean enableRx = this.hasEntities(jpaEntities, nonJpaModels);
        recorder.callHibernateReactiveFeatureInit(enableRx);
    }

    @BuildStep
    public void buildReactivePersistenceUnit(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, BuildProducer<NativeImageResourceBuildItem> resourceProducer, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaEntitiesBuildItem domainObjects, List<NonJpaModelBuildItem> nonJpaModelBuildItems, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorProducer) {
        boolean enableHR = this.hasEntities(domainObjects, nonJpaModelBuildItems);
        if (!enableHR) {
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            String provider = persistenceXmlDescriptorBuildItem.getDescriptor().getProviderClassName();
            if (provider != null && !provider.equals(FastBootHibernateReactivePersistenceProvider.class.getCanonicalName()) && !provider.equals("org.hibernate.reactive.provider.ReactivePersistenceProvider")) continue;
            throw new ConfigurationError("Cannot use persistence.xml with Hibernate Reactive in Quarkus. Must use application.properties instead.");
        }
        Optional dbKindOptional = dataSourcesBuildTimeConfig.defaultDataSource.dbKind;
        if (dbKindOptional.isPresent()) {
            String dbKind = (String)dbKindOptional.get();
            ParsedPersistenceXmlDescriptor reactivePU = this.generateReactivePersistenceUnit(resourceProducer, systemPropertyProducer, dbKind, applicationArchivesBuildItem, launchMode.getLaunchMode());
            persistenceUnitDescriptorProducer.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(reactivePU, true));
        }
    }

    private ParsedPersistenceXmlDescriptor generateReactivePersistenceUnit(BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<SystemPropertyBuildItem> systemProperty, String dbKind, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode) {
        Properties p;
        Optional<String> importFile;
        Optional dialect = this.hibernateConfig.dialect;
        if (!dialect.isPresent()) {
            dialect = HibernateOrmProcessor.guessDialect((String)dbKind);
        }
        String dialectClassName = (String)dialect.get();
        ParsedPersistenceXmlDescriptor desc = new ParsedPersistenceXmlDescriptor(null);
        desc.setName("default-reactive");
        desc.setTransactionType(PersistenceUnitTransactionType.JTA);
        desc.getProperties().setProperty("hibernate.dialect", dialectClassName);
        if (this.hibernateConfig.dialectStorageEngine.isPresent()) {
            systemProperty.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", (String)this.hibernateConfig.dialectStorageEngine.get()));
        }
        this.hibernateConfig.physicalNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        this.hibernateConfig.implicitNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        desc.getProperties().setProperty("javax.persistence.schema-generation.database.action", this.hibernateConfig.database.generation);
        if (this.hibernateConfig.database.generationHaltOnError) {
            desc.getProperties().setProperty("hibernate.hbm2ddl.halt_on_error", "true");
        }
        desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", this.hibernateConfig.database.charset.name());
        this.hibernateConfig.database.defaultCatalog.ifPresent(catalog -> desc.getProperties().setProperty("hibernate.default_catalog", (String)catalog));
        this.hibernateConfig.database.defaultSchema.ifPresent(schema -> desc.getProperties().setProperty("hibernate.default_schema", (String)schema));
        if (this.hibernateConfig.database.globallyQuotedIdentifiers) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (this.hibernateConfig.batchFetchSize > 0) {
            desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(this.hibernateConfig.batchFetchSize));
            desc.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
        }
        this.hibernateConfig.query.queryPlanCacheMaxSize.ifPresent(maxSize -> desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", (String)maxSize));
        this.hibernateConfig.query.defaultNullOrdering.ifPresent(defaultNullOrdering -> desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", (String)defaultNullOrdering));
        if (this.hibernateConfig.log.sql) {
            desc.getProperties().setProperty("hibernate.show_sql", "true");
            desc.getProperties().setProperty("hibernate.format_sql", "true");
        }
        if (this.hibernateConfig.metricsEnabled || this.hibernateConfig.statistics.isPresent() && ((Boolean)this.hibernateConfig.statistics.get()).booleanValue()) {
            desc.getProperties().setProperty("hibernate.generate_statistics", "true");
        }
        if (!(importFile = this.getSqlLoadScript(launchMode)).isPresent()) {
            desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", "no-file");
        } else {
            Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile.get());
            if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile.get()}));
                desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", importFile.get());
                desc.getProperties().setProperty("hibernate.hbm2ddl.import_files_sql_extractor", MultipleLinesSqlCommandExtractor.class.getName());
            } else if (this.hibernateConfig.sqlLoadScript.isPresent()) {
                throw new ConfigurationError("Unable to find file referenced in 'quarkus.hibernate-orm.sql-load-script=" + (String)this.hibernateConfig.sqlLoadScript.get() + "'. Remove property or add file to your path.");
            }
        }
        if (this.hibernateConfig.secondLevelCachingEnabled) {
            p = desc.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("javax.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries((HibernateOrmConfig)this.hibernateConfig);
            for (Map.Entry entry : cacheConfigEntries.entrySet()) {
                desc.getProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            p = desc.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("javax.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
        return desc;
    }

    private Optional<String> getSqlLoadScript(LaunchMode launchMode) {
        if (this.hibernateConfig.sqlLoadScript.isPresent()) {
            if ("no-file".equalsIgnoreCase((String)this.hibernateConfig.sqlLoadScript.get())) {
                return Optional.empty();
            }
            return Optional.of(this.hibernateConfig.sqlLoadScript.get());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Optional.empty();
        }
        return Optional.of("import.sql");
    }

    @BuildStep
    void waitForVertxPool(List<VertxPoolBuildItem> vertxPool, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_REACTIVE));
    }

    private boolean hasEntities(JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        return !jpaEntities.getEntityClassNames().isEmpty() || !nonJpaModels.isEmpty();
    }
}

