/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.RecorderBeanInitializedBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.reactive.deployment.Dialects;
import io.quarkus.hibernate.reactive.deployment.HibernateReactiveEnabled;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import io.quarkus.hibernate.reactive.runtime.ReactiveSessionFactoryProducer;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.reactive.service.internal.ReactiveSessionFactoryServiceContributor;
import org.hibernate.service.spi.SessionFactoryServiceContributor;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateReactiveEnabled.class})
public final class HibernateReactiveProcessor {
    private static final String HIBERNATE_REACTIVE = "Hibernate Reactive";
    private static final Logger LOG = Logger.getLogger(HibernateReactiveProcessor.class);
    static final String[] REFLECTIVE_CONSTRUCTORS_NEEDED = new String[]{"org.hibernate.reactive.persister.entity.impl.ReactiveSingleTableEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveJoinedSubclassEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveUnionSubclassEntityPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveOneToManyPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveBasicCollectionPersister"};

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) {
        if (descriptors.size() == 1) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveSessionFactoryProducer.class}));
        } else {
            LOG.warnf("Skipping registration of %s bean because exactly one persistence unit is required for their registration", (Object)ReactiveSessionFactoryProducer.class.getSimpleName());
        }
    }

    @BuildStep
    void reflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, REFLECTIVE_CONSTRUCTORS_NEEDED));
    }

    @BuildStep
    void services(BuildProducer<ServiceProviderBuildItem> producer) {
        producer.produce((BuildItem)new ServiceProviderBuildItem(SessionFactoryServiceContributor.class.getName(), new String[]{ReactiveSessionFactoryServiceContributor.class.getName()}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateReactiveRecorder recorder, JpaModelBuildItem jpaModel) {
        boolean enableRx = this.hasEntities(jpaModel);
        recorder.callHibernateReactiveFeatureInit(enableRx);
    }

    @BuildStep
    public void buildReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaModelBuildItem jpaModel, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        boolean enableHR = this.hasEntities(jpaModel);
        if (!enableHR) {
            LOG.warn((Object)"Hibernate Reactive is disabled because no JPA entities were found");
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            String provider = persistenceXmlDescriptorBuildItem.getDescriptor().getProviderClassName();
            if (provider != null && !provider.equals(FastBootHibernateReactivePersistenceProvider.class.getCanonicalName()) && !provider.equals("org.hibernate.reactive.provider.ReactivePersistenceProvider")) continue;
            throw new ConfigurationException("Cannot use persistence.xml with Hibernate Reactive in Quarkus. Must use application.properties instead.");
        }
        Optional dbKindOptional = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourcesBuildTimeConfig.defaultDataSource.dbKind, defaultDataSourceDbKindBuildItems, (boolean)dataSourcesBuildTimeConfig.defaultDataSource.devservices.enabled.orElse(dataSourcesBuildTimeConfig.namedDataSources.isEmpty()), (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (dbKindOptional.isPresent()) {
            String dbKind = (String)dbKindOptional.get();
            HibernateOrmConfigPersistenceUnit persistenceUnitConfig = hibernateOrmConfig.defaultPersistenceUnit;
            ParsedPersistenceXmlDescriptor reactivePU = HibernateReactiveProcessor.generateReactivePersistenceUnit(hibernateOrmConfig, index, persistenceUnitConfig, jpaModel, dbKind, applicationArchivesBuildItem, launchMode.getLaunchMode(), systemProperties, nativeImageResources, hotDeploymentWatchedFiles, dbKindDialectBuildItems);
            persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(reactivePU, "<default>", new RecordedConfig(Optional.of("<default>"), dbKindOptional, Optional.empty(), MultiTenancyStrategy.NONE, hibernateOrmConfig.database.ormCompatibilityVersion, persistenceUnitConfig.unsupportedProperties), null, jpaModel.getXmlMappings(reactivePU.getName()), true, false));
        }
    }

    @BuildStep
    void waitForVertxPool(List<VertxPoolBuildItem> vertxPool, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_REACTIVE, puDescriptor.getPersistenceUnitName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    PersistenceProviderSetUpBuildItem setUpPersistenceProviderAndWaitForVertxPool(HibernateReactiveRecorder recorder, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems, BuildProducer<RecorderBeanInitializedBuildItem> orderEnforcer) {
        recorder.initializePersistenceProvider(hibernateOrmRuntimeConfig, HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        return new PersistenceProviderSetUpBuildItem();
    }

    private static ParsedPersistenceXmlDescriptor generateReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, JpaModelBuildItem jpaModel, String dbKind, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        Properties p;
        List<String> importFiles;
        Set modelClassesAndPackages;
        String persistenceUnitConfigName = "<default>";
        Optional explicitDialect = persistenceUnitConfig.dialect.dialect;
        String dialect = explicitDialect.isPresent() ? (String)explicitDialect.get() : Dialects.guessDialect(persistenceUnitConfigName, dbKind, dbKindDialectBuildItems);
        ParsedPersistenceXmlDescriptor desc = new ParsedPersistenceXmlDescriptor(null);
        desc.setName("default-reactive");
        desc.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        desc.getProperties().setProperty("hibernate.dialect", dialect);
        desc.setExcludeUnlistedClasses(true);
        Map modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits((HibernateOrmConfig)hibernateOrmConfig, (JpaModelBuildItem)jpaModel, (IndexView)index.getIndex(), (boolean)true);
        Set nonDefaultPUWithModelClassesOrPackages = modelClassesAndPackagesPerPersistencesUnits.entrySet().stream().filter(e -> !"<default>".equals(e.getKey()) && !((Set)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!nonDefaultPUWithModelClassesOrPackages.isEmpty()) {
            LOG.warnf("Entities are affected to non-default Hibernate Reactive persistence units %s. Since Hibernate Reactive only works with the default persistence unit, those entities will be ignored.", nonDefaultPUWithModelClassesOrPackages);
        }
        if ((modelClassesAndPackages = modelClassesAndPackagesPerPersistencesUnits.getOrDefault("<default>", Collections.emptySet())).isEmpty()) {
            LOG.warnf("Could not find any entities affected to the Hibernate Reactive persistence unit.", new Object[0]);
        } else {
            desc.addClasses(new ArrayList(modelClassesAndPackages));
        }
        if (persistenceUnitConfig.dialect.storageEngine.isPresent()) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", (String)persistenceUnitConfig.dialect.storageEngine.get()));
        }
        persistenceUnitConfig.physicalNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        persistenceUnitConfig.implicitNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        if (persistenceUnitConfig.mapping.timeZoneDefaultStorage.isPresent()) {
            desc.getProperties().setProperty("hibernate.timezone.default_storage", ((TimeZoneStorageType)persistenceUnitConfig.mapping.timeZoneDefaultStorage.get()).name());
        }
        desc.getProperties().setProperty("hibernate.id.optimizer.pooled.preferred", persistenceUnitConfig.mapping.idOptimizerDefault.orElse(HibernateOrmConfigPersistenceUnit.IdOptimizerType.POOLED_LO).configName);
        desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", persistenceUnitConfig.database.charset.name());
        if (persistenceUnitConfig.identifierQuotingStrategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL || persistenceUnitConfig.identifierQuotingStrategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS || persistenceUnitConfig.database.globallyQuotedIdentifiers) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (persistenceUnitConfig.identifierQuotingStrategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ALL_EXCEPT_COLUMN_DEFINITIONS) {
            desc.getProperties().setProperty("hibernate.globally_quoted_identifiers_skip_column_definitions", "true");
        } else if (persistenceUnitConfig.identifierQuotingStrategy == HibernateOrmConfigPersistenceUnit.IdentifierQuotingStrategy.ONLY_KEYWORDS) {
            desc.getProperties().setProperty("hibernate.auto_quote_keyword", "true");
        }
        int batchSize = HibernateConfigUtil.firstPresent((OptionalInt)persistenceUnitConfig.fetch.batchSize, (OptionalInt)persistenceUnitConfig.batchFetchSize).orElse(-1);
        if (batchSize > 0) {
            desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(batchSize));
            desc.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
        }
        if (persistenceUnitConfig.fetch.maxDepth.isPresent()) {
            HibernateReactiveProcessor.setMaxFetchDepth(desc, persistenceUnitConfig.fetch.maxDepth);
        } else if (persistenceUnitConfig.maxFetchDepth.isPresent()) {
            HibernateReactiveProcessor.setMaxFetchDepth(desc, persistenceUnitConfig.maxFetchDepth);
        }
        desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", Integer.toString(persistenceUnitConfig.query.queryPlanCacheMaxSize));
        desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", persistenceUnitConfig.query.defaultNullOrdering.name().toLowerCase());
        desc.getProperties().setProperty("hibernate.query.in_clause_parameter_padding", String.valueOf(persistenceUnitConfig.query.inClauseParameterPadding));
        persistenceUnitConfig.jdbc.timezone.ifPresent(timezone -> desc.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
        persistenceUnitConfig.jdbc.statementFetchSize.ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.fetch_size", String.valueOf(fetchSize)));
        persistenceUnitConfig.jdbc.statementBatchSize.ifPresent(statementBatchSize -> desc.getProperties().setProperty("hibernate.jdbc.batch_size", String.valueOf(statementBatchSize)));
        if (hibernateOrmConfig.metricsEnabled || hibernateOrmConfig.statistics.isPresent() && ((Boolean)hibernateOrmConfig.statistics.get()).booleanValue()) {
            desc.getProperties().setProperty("hibernate.generate_statistics", "true");
        }
        if (!(importFiles = HibernateReactiveProcessor.getSqlLoadScript(persistenceUnitConfig.sqlLoadScript, launchMode)).isEmpty()) {
            for (String importFile : importFiles) {
                Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile);
                if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                    nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile}));
                    hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile));
                    continue;
                }
                if (!persistenceUnitConfig.sqlLoadScript.isPresent()) continue;
                String propertyName = HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnitConfigName, (String)"sql-load-script");
                throw new ConfigurationException("Unable to find file referenced in '" + propertyName + "=" + String.join((CharSequence)",", (Iterable)persistenceUnitConfig.sqlLoadScript.get()) + "'. Remove property or add file to your path.", Collections.singleton(propertyName));
            }
            if (persistenceUnitConfig.sqlLoadScript.isPresent()) {
                desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", String.join((CharSequence)",", importFiles));
            }
        } else {
            desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", "");
        }
        if (persistenceUnitConfig.secondLevelCachingEnabled) {
            p = desc.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("jakarta.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries((HibernateOrmConfigPersistenceUnit)persistenceUnitConfig);
            for (Map.Entry entry : cacheConfigEntries.entrySet()) {
                desc.getProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            p = desc.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("jakarta.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
        return desc;
    }

    private static void setMaxFetchDepth(ParsedPersistenceXmlDescriptor descriptor, OptionalInt maxFetchDepth) {
        descriptor.getProperties().setProperty("hibernate.max_fetch_depth", String.valueOf(maxFetchDepth.getAsInt()));
    }

    private static List<String> getSqlLoadScript(Optional<List<String>> sqlLoadScript, LaunchMode launchMode) {
        if (sqlLoadScript.isPresent()) {
            return sqlLoadScript.get().stream().filter(s -> !"no-file".equalsIgnoreCase((String)s)).collect(Collectors.toList());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Collections.emptyList();
        }
        return List.of("import.sql");
    }

    private boolean hasEntities(JpaModelBuildItem jpaModel) {
        return !jpaModel.getEntityClassNames().isEmpty();
    }
}

