/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.reactive.panache.common.runtime.PanacheHibernateRecorder;
import io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.TestReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.deployment.PanacheNamedQueryEntityClassBuildStep;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.interceptor.Interceptor;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class PanacheJpaCommonResourceProcessor {
    private static final DotName DOTNAME_NAMED_QUERY = DotName.createSimple((String)NamedQuery.class.getName());
    private static final DotName DOTNAME_NAMED_QUERIES = DotName.createSimple((String)NamedQueries.class.getName());
    private static final String TEST_REACTIVE_TRANSACTION = "io.quarkus.test.TestReactiveTransaction";

    @BuildStep(onlyIf={IsTest.class})
    void testTx(BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer)).className(TestReactiveTransactionalInterceptor.class.getName() + "Generated").superClass(TestReactiveTransactionalInterceptor.class).build();){
            c.addAnnotation(TEST_REACTIVE_TRANSACTION);
            c.addAnnotation(Interceptor.class.getName());
            c.addAnnotation(Priority.class).addValue("value", (Object)200);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(TestReactiveTransactionalInterceptor.class).addBeanClass(TEST_REACTIVE_TRANSACTION).build());
    }

    @BuildStep
    void registerInterceptor(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        builder.addBeanClass(ReactiveTransactionalInterceptor.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep
    void lookupNamedQueries(CombinedIndexBuildItem index, BuildProducer<PanacheNamedQueryEntityClassBuildStep> namedQueries, JpaModelBuildItem jpaModel) {
        for (String modelClass : jpaModel.getAllModelClassNames()) {
            HashSet<String> typeNamedQueries = new HashSet<String>();
            this.lookupNamedQueries(index, DotName.createSimple((String)modelClass), typeNamedQueries);
            namedQueries.produce((BuildItem)new PanacheNamedQueryEntityClassBuildStep(modelClass, typeNamedQueries));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildNamedQueryMap(List<PanacheNamedQueryEntityClassBuildStep> namedQueryEntityClasses, PanacheHibernateRecorder panacheHibernateRecorder) {
        HashMap<String, Set<String>> namedQueryMap = new HashMap<String, Set<String>>();
        for (PanacheNamedQueryEntityClassBuildStep entityNamedQueries : namedQueryEntityClasses) {
            namedQueryMap.put(entityNamedQueries.getClassName(), entityNamedQueries.getNamedQueries());
        }
        panacheHibernateRecorder.setNamedQueryMap(namedQueryMap);
    }

    private void lookupNamedQueries(CombinedIndexBuildItem index, DotName name, Set<String> namedQueries) {
        List namedQueriesInstances;
        ClassInfo classInfo = index.getComputingIndex().getClassByName(name);
        if (classInfo == null) {
            return;
        }
        List namedQueryInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERY);
        if (namedQueryInstances != null) {
            for (Object namedQueryInstance : namedQueryInstances) {
                namedQueries.add(namedQueryInstance.value("name").asString());
            }
        }
        if ((namedQueriesInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERIES)) != null) {
            for (AnnotationInstance namedQueriesInstance : namedQueriesInstances) {
                AnnotationInstance[] nestedInstances;
                AnnotationValue value = namedQueriesInstance.value();
                for (AnnotationInstance nested : nestedInstances = value.asNestedArray()) {
                    namedQueries.add(nested.value("name").asString());
                }
            }
        }
        if (!classInfo.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = classInfo.superClassType();
            ClassInfo superClass = index.getComputingIndex().getClassByName(superType.name());
            if (superClass != null) {
                this.lookupNamedQueries(index, superClass.name(), namedQueries);
            }
        }
    }
}

