/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.reactive.panache.common.WithSession;
import io.quarkus.hibernate.reactive.panache.common.WithSessionOnDemand;
import io.quarkus.hibernate.reactive.panache.common.WithTransaction;
import io.quarkus.hibernate.reactive.panache.common.deployment.PanacheNamedQueryEntityClassBuildStep;
import io.quarkus.hibernate.reactive.panache.common.runtime.PanacheHibernateRecorder;
import io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactional;
import io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.TestReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.WithSessionInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.WithSessionOnDemandInterceptor;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.interceptor.Interceptor;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class PanacheJpaCommonResourceProcessor {
    private static final Logger LOG = Logger.getLogger(PanacheJpaCommonResourceProcessor.class);
    private static final DotName DOTNAME_NAMED_QUERY = DotName.createSimple((String)NamedQuery.class.getName());
    private static final DotName DOTNAME_NAMED_QUERIES = DotName.createSimple((String)NamedQueries.class.getName());
    private static final String TEST_REACTIVE_TRANSACTION = "io.quarkus.test.TestReactiveTransaction";
    private static final DotName REACTIVE_TRANSACTIONAL = DotName.createSimple((String)ReactiveTransactional.class.getName());
    private static final DotName WITH_SESSION_ON_DEMAND = DotName.createSimple((String)WithSessionOnDemand.class.getName());
    private static final DotName WITH_SESSION = DotName.createSimple((String)WithSession.class.getName());
    private static final DotName WITH_TRANSACTION = DotName.createSimple((String)WithTransaction.class.getName());
    private static final DotName UNI = DotName.createSimple((String)Uni.class.getName());
    private static final DotName PANACHE_ENTITY_BASE = DotName.createSimple((String)"io.quarkus.hibernate.reactive.panache.PanacheEntityBase");
    private static final DotName PANACHE_ENTITY = DotName.createSimple((String)"io.quarkus.hibernate.reactive.panache.PanacheEntity");
    private static final DotName PANACHE_KOTLIN_ENTITY_BASE = DotName.createSimple((String)"io.quarkus.hibernate.reactive.panache.kotlin.PanacheEntityBase");
    private static final DotName PANACHE_KOTLIN_ENTITY = DotName.createSimple((String)"io.quarkus.hibernate.reactive.panache.kotlin.PanacheEntity");

    @BuildStep(onlyIf={IsTest.class})
    void testTx(BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer)).className(TestReactiveTransactionalInterceptor.class.getName() + "Generated").superClass(TestReactiveTransactionalInterceptor.class).build();){
            c.addAnnotation(TEST_REACTIVE_TRANSACTION);
            c.addAnnotation(Interceptor.class.getName());
            c.addAnnotation(Priority.class).addValue("value", (Object)200);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(TestReactiveTransactionalInterceptor.class).addBeanClass(TEST_REACTIVE_TRANSACTION).build());
    }

    @BuildStep
    void registerInterceptors(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        builder.addBeanClass(WithSessionOnDemandInterceptor.class);
        builder.addBeanClass(WithSessionInterceptor.class);
        builder.addBeanClass(ReactiveTransactionalInterceptor.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep
    void validateInterceptedMethods(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        List<DotName> bindings = List.of(REACTIVE_TRANSACTIONAL, WITH_SESSION, WITH_SESSION_ON_DEMAND, WITH_TRANSACTION);
        for (BeanInfo bean : validationPhase.getContext().beans().withAroundInvokeInterceptor()) {
            for (Map.Entry<MethodInfo, Set<AnnotationInstance>> entry : bean.getInterceptedMethodsBindings().entrySet()) {
                DotName returnTypeName = ((MethodInfo)entry.getKey()).returnType().name();
                if (returnTypeName.equals((Object)UNI)) continue;
                this.validateBindings(bindings, entry, errors);
            }
        }
    }

    @BuildStep
    void transformResourceMethods(CombinedIndexBuildItem index, Capabilities capabilities, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            final List<DotName> designators = List.of(DotName.createSimple((String)"jakarta.ws.rs.GET"), DotName.createSimple((String)"jakarta.ws.rs.HEAD"), DotName.createSimple((String)"jakarta.ws.rs.DELETE"), DotName.createSimple((String)"jakarta.ws.rs.OPTIONS"), DotName.createSimple((String)"jakarta.ws.rs.PATCH"), DotName.createSimple((String)"jakarta.ws.rs.POST"), DotName.createSimple((String)"jakarta.ws.rs.PUT"));
            final List<DotName> bindings = List.of(REACTIVE_TRANSACTIONAL, WITH_SESSION, WITH_SESSION_ON_DEMAND, WITH_TRANSACTION);
            HashSet<DotName> entities = new HashSet<DotName>();
            for (ClassInfo subclass : index.getIndex().getAllKnownSubclasses(PANACHE_ENTITY_BASE)) {
                if (subclass.name().equals((Object)PANACHE_ENTITY)) continue;
                entities.add(subclass.name());
            }
            for (ClassInfo subclass : index.getIndex().getAllKnownImplementors(PANACHE_KOTLIN_ENTITY_BASE)) {
                if (subclass.name().equals((Object)PANACHE_KOTLIN_ENTITY)) continue;
                entities.add(subclass.name());
            }
            final HashSet<DotName> entityUsers = new HashSet<DotName>();
            for (DotName entity : entities) {
                for (ClassInfo user : index.getIndex().getKnownUsers(entity)) {
                    entityUsers.add(user.name());
                }
            }
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.METHOD;
                }

                public void transform(AnnotationsTransformer.TransformationContext context) {
                    MethodInfo method = context.getTarget().asMethod();
                    Collection annotations = context.getAnnotations();
                    if (method.isSynthetic() || Modifier.isStatic(method.flags()) || method.declaringClass().isInterface() || !method.returnType().name().equals((Object)UNI) || !entityUsers.contains(method.declaringClass().name()) || !Annotations.containsAny((Collection)annotations, (Iterable)designators) || Annotations.containsAny((Collection)annotations, (Iterable)bindings)) {
                        return;
                    }
                    ((Transformation)context.transform().add(WITH_SESSION_ON_DEMAND, new AnnotationValue[0])).done();
                }
            }));
        }
    }

    @BuildStep
    void lookupNamedQueries(CombinedIndexBuildItem index, BuildProducer<PanacheNamedQueryEntityClassBuildStep> namedQueries, JpaModelBuildItem jpaModel) {
        for (String modelClass : jpaModel.getAllModelClassNames()) {
            HashSet<String> typeNamedQueries = new HashSet<String>();
            this.lookupNamedQueries(index, DotName.createSimple((String)modelClass), typeNamedQueries);
            namedQueries.produce((BuildItem)new PanacheNamedQueryEntityClassBuildStep(modelClass, typeNamedQueries));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildNamedQueryMap(List<PanacheNamedQueryEntityClassBuildStep> namedQueryEntityClasses, PanacheHibernateRecorder panacheHibernateRecorder) {
        HashMap<String, Set<String>> namedQueryMap = new HashMap<String, Set<String>>();
        for (PanacheNamedQueryEntityClassBuildStep entityNamedQueries : namedQueryEntityClasses) {
            namedQueryMap.put(entityNamedQueries.getClassName(), entityNamedQueries.getNamedQueries());
        }
        panacheHibernateRecorder.setNamedQueryMap(namedQueryMap);
    }

    private void lookupNamedQueries(CombinedIndexBuildItem index, DotName name, Set<String> namedQueries) {
        List namedQueriesInstances;
        ClassInfo classInfo = index.getComputingIndex().getClassByName(name);
        if (classInfo == null) {
            return;
        }
        List namedQueryInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERY);
        if (namedQueryInstances != null) {
            for (Object namedQueryInstance : namedQueryInstances) {
                namedQueries.add(namedQueryInstance.value("name").asString());
            }
        }
        if ((namedQueriesInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERIES)) != null) {
            for (AnnotationInstance namedQueriesInstance : namedQueriesInstances) {
                AnnotationInstance[] nestedInstances;
                AnnotationValue value = namedQueriesInstance.value();
                for (AnnotationInstance nested : nestedInstances = value.asNestedArray()) {
                    namedQueries.add(nested.value("name").asString());
                }
            }
        }
        if (!classInfo.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = classInfo.superClassType();
            ClassInfo superClass = index.getComputingIndex().getClassByName(superType.name());
            if (superClass != null) {
                this.lookupNamedQueries(index, superClass.name(), namedQueries);
            }
        }
    }

    private void validateBindings(List<DotName> bindings, Map.Entry<MethodInfo, Set<AnnotationInstance>> entry, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        for (DotName binding : bindings) {
            for (AnnotationInstance annotation : entry.getValue()) {
                if (!annotation.name().equals((Object)binding)) continue;
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A method annotated with @" + binding.withoutPackagePrefix() + " must return io.smallrye.mutiny.Uni: " + entry.getKey() + " declared on " + entry.getKey().declaringClass())}));
                } else {
                    LOG.debugf("Class-level binding %s will be ignored for method %s() declared on %s", (Object)binding, (Object)entry.getKey().name(), (Object)entry.getKey().declaringClass());
                }
                return;
            }
        }
    }
}

