/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.reactive.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    protected abstract PanacheQueryType createPanacheQuery(Mutiny.Session var1, String var2, String var3, Object var4);

    protected abstract Uni<List<?>> list(PanacheQueryType var1);

    protected abstract Multi<?> stream(PanacheQueryType var1);

    public Uni<Void> persist(Object entity) {
        return this.persist(AbstractJpaOperations.getSession(), entity);
    }

    public Uni<Void> persist(Mutiny.Session session, Object entity) {
        if (!session.contains(entity)) {
            return session.persist(entity).map(v -> null);
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<Void> persist(Iterable<?> entities) {
        return this.persist(StreamSupport.stream(entities.spliterator(), false));
    }

    public Uni<Void> persist(Object firstEntity, Object ... entities) {
        ArrayList<Object> array = new ArrayList<Object>(entities.length + 1);
        array.add(firstEntity);
        for (Object entity : entities) {
            array.add(entity);
        }
        return this.persist(array.stream());
    }

    public Uni<Void> persist(Stream<?> entities) {
        Mutiny.Session session = AbstractJpaOperations.getSession();
        List uniList = entities.map(entity -> this.persist(session, entity)).collect(Collectors.toList());
        return Uni.combine().all().unis(uniList).discardItems();
    }

    public Uni<Void> delete(Object entity) {
        return AbstractJpaOperations.getSession().remove(entity).map(v -> null);
    }

    public boolean isPersistent(Object entity) {
        return AbstractJpaOperations.getSession().contains(entity);
    }

    public Uni<Void> flush() {
        return AbstractJpaOperations.getSession().flush().map(v -> null);
    }

    public static Mutiny.Session getSession() {
        Mutiny.Session session = (Mutiny.Session)Arc.container().instance(Mutiny.Session.class, new Annotation[0]).get();
        if (session == null) {
            throw new PersistenceException("No Mutiny.Session found. Do you have any JPA entities defined?");
        }
        return session;
    }

    public static Mutiny.Query<?> bindParameters(Mutiny.Query<?> query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Mutiny.Query<?> bindParameters(Mutiny.Query<?> query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Uni<?> findById(Class<?> entityClass, Object id) {
        return AbstractJpaOperations.getSession().find(entityClass, id);
    }

    public Uni<?> findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return AbstractJpaOperations.getSession().find(entityClass, id, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        Mutiny.Session session = AbstractJpaOperations.getSession();
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(session, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        Mutiny.Session session = AbstractJpaOperations.getSession();
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(session, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Mutiny.Session session = AbstractJpaOperations.getSession();
        return this.createPanacheQuery(session, query, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Mutiny.Session session = AbstractJpaOperations.getSession();
        return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public Uni<List<?>> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public Uni<List<?>> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Multi<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Multi<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public Uni<Long> count(Class<?> entityClass) {
        return AbstractJpaOperations.getSession().createQuery("SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass)).getSingleResult();
    }

    public Uni<Long> count(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.bindParameters(AbstractJpaOperations.getSession().createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult();
    }

    public Uni<Long> count(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.bindParameters(AbstractJpaOperations.getSession().createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult();
    }

    public Uni<Long> count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public Uni<Boolean> exists(Class<?> entityClass) {
        return this.count(entityClass).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Long> deleteAll(Class<?> entityClass) {
        return AbstractJpaOperations.getSession().createQuery("DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass)).executeUpdate().map(i -> i.longValue());
    }

    public Uni<Boolean> deleteById(Class<?> entityClass, Object id) {
        return this.findById(entityClass, id).flatMap(entity -> {
            if (entity == null) {
                return Uni.createFrom().item((Object)false);
            }
            return AbstractJpaOperations.getSession().remove(entity).map(v -> true);
        });
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.bindParameters(AbstractJpaOperations.getSession().createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate().map(i -> i.longValue());
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.bindParameters(AbstractJpaOperations.getSession().createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate().map(i -> i.longValue());
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public static Uni<Integer> executeUpdate(String query, Object ... params) {
        Mutiny.Query jpaQuery = AbstractJpaOperations.getSession().createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public static Uni<Integer> executeUpdate(String query, Map<String, Object> params) {
        Mutiny.Query jpaQuery = AbstractJpaOperations.getSession().createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String query, Object ... params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return AbstractJpaOperations.executeUpdate(updateQuery, params);
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String query, Map<String, Object> params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return AbstractJpaOperations.executeUpdate(updateQuery, params);
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }
}

