/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import javax.persistence.LockModeType;
import org.hibernate.Filter;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.reactive.mutiny.Mutiny;

public class CommonPanacheQueryImpl<Entity> {
    private Object paramsArrayOrMap;
    private String query;
    protected String countQuery;
    private String orderBy;
    private Mutiny.Session em;
    private Page page;
    private Uni<Long> count;
    private Range range;
    private LockModeType lockModeType;
    private Map<String, Object> hints;
    private Map<String, Map<String, Object>> filters;

    public CommonPanacheQueryImpl(Mutiny.Session em, String query, String orderBy, Object paramsArrayOrMap) {
        this.em = em;
        this.query = query;
        this.orderBy = orderBy;
        this.paramsArrayOrMap = paramsArrayOrMap;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, String newQueryString, String countQuery) {
        this.em = previousQuery.em;
        this.query = newQueryString;
        this.countQuery = countQuery;
        this.orderBy = previousQuery.orderBy;
        this.paramsArrayOrMap = previousQuery.paramsArrayOrMap;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.lockModeType = previousQuery.lockModeType;
        this.hints = previousQuery.hints;
        this.filters = previousQuery.filters;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            throw new PanacheQueryException("Unable to perform a projection on a named query");
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        StringBuilder select = new StringBuilder("SELECT new ").append(type.getName()).append(" (");
        int selectInitialLength = select.length();
        for (Parameter parameter : constructor.getParameters()) {
            if (!parameter.isNamePresent()) {
                throw new PanacheQueryException("Your application must be built with parameter names, this should be the default if using Quarkus artifacts. Check the maven or gradle compiler configuration to include '-parameters'.");
            }
            if (select.length() > selectInitialLength) {
                select.append(", ");
            }
            select.append(parameter.getName());
        }
        select.append(") ");
        return new CommonPanacheQueryImpl<Entity>(this, select.toString() + this.query, "select count(*) " + this.query);
    }

    public void filter(String filterName, Map<String, Object> parameters) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Map<String, Object>>();
        }
        this.filters.put(filterName, parameters);
    }

    public void page(Page page) {
        this.page = page;
        this.range = null;
    }

    public void page(int pageIndex, int pageSize) {
        this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public void nextPage() {
        this.checkPagination();
        this.page(this.page.next());
    }

    public void previousPage() {
        this.checkPagination();
        this.page(this.page.previous());
    }

    public void firstPage() {
        this.checkPagination();
        this.page(this.page.first());
    }

    public Uni<Void> lastPage() {
        this.checkPagination();
        return this.pageCount().map(count -> {
            this.page(this.page.index(count - 1));
            return null;
        });
    }

    public Uni<Boolean> hasNextPage() {
        this.checkPagination();
        return this.pageCount().map(pageCount -> this.page.index < pageCount - 1);
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public Uni<Integer> pageCount() {
        this.checkPagination();
        return this.count().map(count -> {
            if (count == 0L) {
                return 1;
            }
            return (int)Math.ceil((double)count.longValue() / (double)this.page.size);
        });
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public void range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
    }

    public void withLock(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void withHint(String hintName, Object value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, Object>();
        }
        this.hints.put(hintName, value);
        throw new UnsupportedOperationException("Hints not supported yet");
    }

    public Uni<Long> count() {
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            throw new PanacheQueryException("Unable to perform a count operation on a named query");
        }
        if (this.count == null) {
            Mutiny.Query countQuery = this.em.createQuery(this.countQuery());
            if (this.paramsArrayOrMap instanceof Map) {
                AbstractJpaOperations.bindParameters(countQuery, (Map)this.paramsArrayOrMap);
            } else {
                AbstractJpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
            }
            this.count = this.applyFilters(this.em, () -> countQuery.getSingleResult());
        }
        return this.count;
    }

    private String countQuery() {
        if (this.countQuery != null) {
            return this.countQuery;
        }
        return PanacheJpaUtil.getCountQuery((String)this.query);
    }

    public <T extends Entity> Uni<List<T>> list() {
        Mutiny.Query<?> jpaQuery = this.createQuery(this.em);
        return this.applyFilters(this.em, () -> jpaQuery.getResultList());
    }

    public <T extends Entity> Multi<T> stream() {
        Uni<List<T>> results = this.list();
        return results.toMulti().flatMap(list -> Multi.createFrom().iterable((Iterable)list));
    }

    public <T extends Entity> Uni<T> firstResult() {
        Mutiny.Query<?> jpaQuery = this.createQuery(this.em, 1);
        return this.applyFilters(this.em, () -> jpaQuery.getResultList().map(list -> list.isEmpty() ? null : list.get(0)));
    }

    public <T extends Entity> Uni<T> singleResult() {
        Mutiny.Query<?> jpaQuery = this.createQuery(this.em);
        return this.applyFilters(this.em, () -> jpaQuery.getSingleResult().map(v -> v)).onFailure(CompletionException.class).transform(t -> t.getCause());
    }

    private Mutiny.Query<?> createQuery(Mutiny.Session em) {
        Mutiny.Query<?> jpaQuery = this.createBaseQuery(em);
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
            jpaQuery.setMaxResults(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
            jpaQuery.setMaxResults(this.page.size);
        }
        return jpaQuery;
    }

    private Mutiny.Query<?> createQuery(Mutiny.Session em, int maxResults) {
        Mutiny.Query<?> jpaQuery = this.createBaseQuery(em);
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
        } else {
            jpaQuery.setFirstResult(0);
        }
        jpaQuery.setMaxResults(maxResults);
        return jpaQuery;
    }

    private Mutiny.Query<?> createBaseQuery(Mutiny.Session em) {
        Mutiny.Query jpaQuery;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            String namedQuery = this.query.substring(1);
            jpaQuery = em.createNamedQuery(namedQuery);
        } else {
            jpaQuery = em.createQuery((String)(this.orderBy != null ? this.query + this.orderBy : this.query));
        }
        if (this.paramsArrayOrMap instanceof Map) {
            AbstractJpaOperations.bindParameters(jpaQuery, (Map)this.paramsArrayOrMap);
        } else {
            AbstractJpaOperations.bindParameters(jpaQuery, (Object[])this.paramsArrayOrMap);
        }
        if (this.lockModeType != null) {
            jpaQuery.setLockMode(LockModeConverter.convertToLockMode((LockModeType)this.lockModeType));
        }
        if (this.hints != null) {
            // empty if block
        }
        return jpaQuery;
    }

    private <T> Uni<T> applyFilters(Mutiny.Session em, Supplier<Uni<T>> uni) {
        if (this.filters == null) {
            return uni.get();
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
            Filter filter = em.enableFilter(entry.getKey());
            for (Map.Entry<String, Object> paramEntry : entry.getValue().entrySet()) {
                filter.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            filter.validate();
        }
        return uni.get().onTermination().invoke(() -> {
            for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
                em.disableFilter(entry.getKey());
            }
        });
    }
}

