/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.runtime.AbstractJpaOperations;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class ReactiveTransactionalInterceptorBase {
    private static final String JUNIT_TEST_CLASS = "org.junit.jupiter.api.Test";
    private static final String UNI_ASSERTER_CLASS = "io.quarkus.test.junit.vertx.UniAsserter";

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        Class<?> returnType = ic.getMethod().getReturnType();
        if (returnType == Uni.class) {
            return AbstractJpaOperations.getSession().flatMap(session -> session.withTransaction(tx -> {
                this.inTransactionCallback((Mutiny.Transaction)tx);
                try {
                    return (Uni)ic.proceed();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        if (Context.isOnVertxThread()) {
            if (this.isSpecialTestMethod(ic)) {
                return this.handleSpecialTestMethod(ic);
            }
            throw new RuntimeException("Unsupported return type " + returnType + " in method " + ic.getMethod() + ": only Uni is supported when using @ReactiveTransaction if you are running on a VertxThread");
        }
        Uni ret = AbstractJpaOperations.getSession().flatMap(session -> session.withTransaction(tx -> {
            this.inTransactionCallback((Mutiny.Transaction)tx);
            try {
                return Uni.createFrom().item(ic.proceed());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        return ret.await().atMost(Duration.ofMillis(5000L));
    }

    protected boolean isSpecialTestMethod(InvocationContext ic) {
        Method method = ic.getMethod();
        return this.hasAnnotation(JUNIT_TEST_CLASS, method) && this.hasParameter(UNI_ASSERTER_CLASS, method);
    }

    protected Object handleSpecialTestMethod(InvocationContext ic) {
        Class<?>[] parameterTypes = ic.getMethod().getParameterTypes();
        Object uniAsserter = null;
        Class<?> uniAsserterClass = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> klass = parameterTypes[i];
            if (!klass.getName().equals(UNI_ASSERTER_CLASS)) continue;
            uniAsserter = ic.getParameters()[i];
            uniAsserterClass = klass;
            break;
        }
        if (uniAsserter == null) {
            throw new AssertionError((Object)"We could not find the right UniAsserter parameter, please file a bug report");
        }
        try {
            Method execute = uniAsserterClass.getMethod("surroundWith", Function.class);
            try {
                ic.proceed();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            execute.invoke(uniAsserter, new Function<Uni<?>, Uni<?>>(){

                @Override
                public Uni<?> apply(Uni<?> t) {
                    return AbstractJpaOperations.getSession().flatMap(session -> session.withTransaction(tx -> {
                        ReactiveTransactionalInterceptorBase.this.inTransactionCallback((Mutiny.Transaction)tx);
                        return t;
                    }));
                }
            });
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AssertionError("Reflective call to UniAsserter parameter failed, please file a bug report", e);
        }
    }

    private boolean hasParameter(String parameterType, Method method) {
        for (Class<?> klass : method.getParameterTypes()) {
            if (!klass.getName().equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(String annotationName, Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    protected void inTransactionCallback(Mutiny.Transaction tx) {
    }
}

