/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.reactive.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.spi.Contextual;
import javax.persistence.LockModeType;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    static final long TIMEOUT_MS = 5000L;

    private static void executeInVertxEventLoop(Runnable runnable) {
        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
        CompletableFuture cf = new CompletableFuture();
        vertx.runOnContext(v -> {
            try {
                runnable.run();
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        try {
            cf.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static Mutiny.Session lookupSessionFromArc() {
        return (Mutiny.Session)Arc.container().instance(Mutiny.Session.class, new Annotation[0]).get();
    }

    protected abstract PanacheQueryType createPanacheQuery(Uni<Mutiny.Session> var1, String var2, String var3, Object var4);

    protected abstract Uni<List<?>> list(PanacheQueryType var1);

    protected abstract Multi<?> stream(PanacheQueryType var1);

    public Uni<Void> persist(Object entity) {
        return this.persist(AbstractJpaOperations.getSession(), entity);
    }

    public Uni<Void> persist(Uni<Mutiny.Session> sessionUni, Object entity) {
        return sessionUni.chain(session -> {
            if (!session.contains(entity)) {
                return session.persist(entity);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public Uni<Void> persist(Iterable<?> entities) {
        return this.persist(StreamSupport.stream(entities.spliterator(), false));
    }

    public Uni<Void> persist(Object firstEntity, Object ... entities) {
        ArrayList<Object> array = new ArrayList<Object>(entities.length + 1);
        array.add(firstEntity);
        for (Object entity : entities) {
            array.add(entity);
        }
        return this.persist(array.stream());
    }

    public Uni<Void> persist(Stream<?> entities) {
        Uni<Mutiny.Session> session = AbstractJpaOperations.getSession();
        List uniList = entities.map(entity -> this.persist(session, entity)).collect(Collectors.toList());
        return Uni.combine().all().unis(uniList).discardItems();
    }

    public Uni<Void> delete(Object entity) {
        return AbstractJpaOperations.getSession().chain(session -> session.remove(entity));
    }

    public boolean isPersistent(Object entity) {
        Mutiny.Session requestSession;
        Object object = requestSession = AbstractJpaOperations.isInRequestContext(Mutiny.Session.class) ? AbstractJpaOperations.lookupSessionFromArc() : null;
        if (requestSession != null) {
            return requestSession.contains(entity);
        }
        return false;
    }

    public Uni<Void> flush() {
        return AbstractJpaOperations.getSession().chain(Mutiny.Session::flush);
    }

    public static Uni<Mutiny.Session> getSession() {
        if (Context.isOnEventLoopThread()) {
            return Uni.createFrom().item((Object)AbstractJpaOperations.lookupSessionFromArc());
        }
        Executor executor = AbstractJpaOperations::executeInVertxEventLoop;
        return Uni.createFrom().item(AbstractJpaOperations::lookupSessionFromArc).runSubscriptionOn(executor);
    }

    private static boolean isInRequestContext(Class<?> klass) {
        Set beans = Arc.container().beanManager().getBeans(klass, new Annotation[0]);
        if (beans.isEmpty()) {
            return false;
        }
        return Arc.container().requestContext().get((Contextual)beans.iterator().next()) != null;
    }

    public static Mutiny.Query<?> bindParameters(Mutiny.Query<?> query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Mutiny.Query<?> bindParameters(Mutiny.Query<?> query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Uni<?> findById(Class<?> entityClass, Object id) {
        return AbstractJpaOperations.getSession().chain(session -> session.find(entityClass, id));
    }

    public Uni<?> findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return AbstractJpaOperations.getSession().chain(session -> session.find(entityClass, id, LockModeConverter.convertToLockMode((LockModeType)lockModeType)));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        Uni<Mutiny.Session> session = AbstractJpaOperations.getSession();
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(session, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        Uni<Mutiny.Session> session = AbstractJpaOperations.getSession();
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(session, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Uni<Mutiny.Session> session = AbstractJpaOperations.getSession();
        return this.createPanacheQuery(session, query, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Uni<Mutiny.Session> session = AbstractJpaOperations.getSession();
        return this.createPanacheQuery(session, query, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public Uni<List<?>> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public Uni<List<?>> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Multi<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Multi<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public Uni<Long> count(Class<?> entityClass) {
        return AbstractJpaOperations.getSession().chain(session -> session.createQuery("SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName((Class)entityClass)).getSingleResult());
    }

    public Uni<Long> count(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.getSession().chain(session -> AbstractJpaOperations.bindParameters(session.createQuery(PanacheJpaUtil.createCountQuery((Class)entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult());
    }

    public Uni<Long> count(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.getSession().chain(session -> AbstractJpaOperations.bindParameters(session.createQuery(PanacheJpaUtil.createCountQuery((Class)entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult());
    }

    public Uni<Long> count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public Uni<Boolean> exists(Class<?> entityClass) {
        return this.count(entityClass).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Long> deleteAll(Class<?> entityClass) {
        return AbstractJpaOperations.getSession().chain(session -> session.createQuery("DELETE FROM " + PanacheJpaUtil.getEntityName((Class)entityClass)).executeUpdate().map(Integer::longValue));
    }

    public Uni<Boolean> deleteById(Class<?> entityClass, Object id) {
        return this.findById(entityClass, id).chain(entity -> {
            if (entity == null) {
                return Uni.createFrom().item((Object)false);
            }
            return AbstractJpaOperations.getSession().chain(session -> session.remove(entity).map(v -> true));
        });
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.getSession().chain(session -> AbstractJpaOperations.bindParameters(session.createQuery(PanacheJpaUtil.createDeleteQuery((Class)entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate().map(Integer::longValue));
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.getSession().chain(session -> AbstractJpaOperations.bindParameters(session.createQuery(PanacheJpaUtil.createDeleteQuery((Class)entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate().map(Integer::longValue));
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public static Uni<Integer> executeUpdate(String query, Object ... params) {
        return AbstractJpaOperations.getSession().chain(session -> {
            Mutiny.Query jpaQuery = session.createQuery(query);
            AbstractJpaOperations.bindParameters(jpaQuery, params);
            return jpaQuery.executeUpdate();
        });
    }

    public static Uni<Integer> executeUpdate(String query, Map<String, Object> params) {
        return AbstractJpaOperations.getSession().chain(session -> {
            Mutiny.Query jpaQuery = session.createQuery(query);
            AbstractJpaOperations.bindParameters(jpaQuery, params);
            return jpaQuery.executeUpdate();
        });
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String query, Object ... params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return AbstractJpaOperations.executeUpdate(updateQuery, params);
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String query, Map<String, Object> params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return AbstractJpaOperations.executeUpdate(updateQuery, params);
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }
}

