/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations;
import io.smallrye.mutiny.Uni;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

public class TestReactiveTransactionalInterceptor {
    private static final String JUNIT_TEST_ANN = "org.junit.jupiter.api.Test";
    private static final String JUNIT_BEFORE_EACH_ANN = "org.junit.jupiter.api.BeforeEach";
    private static final String JUNIT_AFTER_EACH_ANN = "org.junit.jupiter.api.AfterEach";
    private static final String UNI_ASSERTER_CLASS = "io.quarkus.test.vertx.UniAsserter";

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (this.isSpecialTestMethod(context)) {
            return this.handleSpecialTestMethod(context);
        }
        throw new IllegalStateException("A test method annotated with @TestReactiveTransaction must accept io.quarkus.test.vertx.UniAsserter");
    }

    protected boolean isSpecialTestMethod(InvocationContext ic) {
        Method method = ic.getMethod();
        return this.hasParameter(UNI_ASSERTER_CLASS, method) && (this.hasAnnotation(JUNIT_TEST_ANN, method) || this.hasAnnotation(JUNIT_BEFORE_EACH_ANN, method) || this.hasAnnotation(JUNIT_AFTER_EACH_ANN, method));
    }

    protected Object handleSpecialTestMethod(InvocationContext ic) {
        Class<?>[] parameterTypes = ic.getMethod().getParameterTypes();
        Object uniAsserter = null;
        Class<?> uniAsserterClass = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> klass = parameterTypes[i];
            if (!klass.getName().equals(UNI_ASSERTER_CLASS)) continue;
            uniAsserter = ic.getParameters()[i];
            uniAsserterClass = klass;
            break;
        }
        if (uniAsserter == null) {
            throw new AssertionError((Object)"We could not find the right UniAsserter parameter, please file a bug report");
        }
        try {
            Method execute = uniAsserterClass.getMethod("surroundWith", Function.class);
            try {
                ic.proceed();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            execute.invoke(uniAsserter, new Function<Uni<?>, Uni<?>>(){

                @Override
                public Uni<?> apply(Uni<?> t) {
                    return SessionOperations.withTransaction(tx -> {
                        tx.markForRollback();
                        return t;
                    });
                }
            });
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AssertionError("Reflective call to UniAsserter parameter failed, please file a bug report", e);
        }
    }

    private boolean hasParameter(String parameterType, Method method) {
        for (Class<?> klass : method.getParameterTypes()) {
            if (!klass.getName().equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(String annotationName, Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

