/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.NestedProjectedClass;
import io.quarkus.hibernate.reactive.panache.common.ProjectedFieldName;
import io.quarkus.hibernate.reactive.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.reactive.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.persistence.LockModeType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Filter;
import org.hibernate.reactive.mutiny.Mutiny;

public class CommonPanacheQueryImpl<Entity> {
    private Object paramsArrayOrMap;
    private String query;
    private String originalQuery;
    protected String countQuery;
    private String orderBy;
    private Uni<Mutiny.Session> em;
    private Page page;
    private Uni<Long> count;
    private Range range;
    private LockModeType lockModeType;
    private Map<String, Object> hints;
    private Map<String, Map<String, Object>> filters;
    private Class<?> projectionType;

    public CommonPanacheQueryImpl(Uni<Mutiny.Session> em, String query, String originalQuery, String orderBy, Object paramsArrayOrMap) {
        this.em = em;
        this.query = query;
        this.originalQuery = originalQuery;
        this.orderBy = orderBy;
        this.paramsArrayOrMap = paramsArrayOrMap;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, String newQueryString, String countQuery, Class<?> projectionType) {
        this.em = previousQuery.em;
        this.query = newQueryString;
        this.countQuery = countQuery;
        this.orderBy = previousQuery.orderBy;
        this.paramsArrayOrMap = previousQuery.paramsArrayOrMap;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.lockModeType = previousQuery.lockModeType;
        this.hints = previousQuery.hints;
        this.filters = previousQuery.filters;
        this.projectionType = projectionType;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        String lowerCasedTrimmedQuery;
        String selectQuery = this.query;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            selectQuery = NamedQueryUtil.getNamedQuery(this.query.substring(1));
        }
        if ((lowerCasedTrimmedQuery = PanacheJpaUtil.trimForAnalysis((String)selectQuery)).startsWith("select new ") || lowerCasedTrimmedQuery.startsWith("select distinct new ")) {
            throw new PanacheQueryException("Unable to perform a projection on a 'select [distinct]? new' query: " + this.query);
        }
        if (lowerCasedTrimmedQuery.startsWith("select ")) {
            return new CommonPanacheQueryImpl<Entity>(this, this.query, this.countQuery, type);
        }
        String selectClause = "SELECT " + this.getParametersFromClass(type, null);
        return new CommonPanacheQueryImpl<Entity>(this, selectClause + selectQuery, "select count(*) " + selectQuery, type);
    }

    private StringBuilder getParametersFromClass(Class<?> type, String parentParameter) {
        StringBuilder selectClause = new StringBuilder();
        Constructor<?> constructor = this.getConstructor(type);
        selectClause.append("new ").append(type.getName()).append(" (");
        String parametersListStr = Stream.of(constructor.getParameters()).map(parameter -> this.getParameterName(type, parentParameter, (Parameter)parameter)).collect(Collectors.joining(","));
        selectClause.append(parametersListStr);
        selectClause.append(") ");
        return selectClause;
    }

    private Constructor<?> getConstructor(Class<?> type) {
        return type.getDeclaredConstructors()[0];
    }

    private String getParameterName(Class<?> parentType, String parentParameter, Parameter parameter) {
        String parameterName;
        if (this.hasProjectedFieldName(parameter)) {
            parameterName = this.getNameFromProjectedFieldName(parameter);
        } else {
            if (!parameter.isNamePresent()) {
                throw new PanacheQueryException("Your application must be built with parameter names, this should be the default if using Quarkus project generation. Check the Maven or Gradle compiler configuration to include '-parameters'.");
            }
            try {
                Field field = parentType.getDeclaredField(parameter.getName());
                parameterName = this.hasProjectedFieldName(field) ? this.getNameFromProjectedFieldName(field) : parameter.getName();
            }
            catch (NoSuchFieldException e) {
                parameterName = parameter.getName();
            }
        }
        String string = parameterName = parentParameter == null ? parameterName : parentParameter.concat(".").concat(parameterName);
        if (parameter.getType().isAnnotationPresent(NestedProjectedClass.class)) {
            Class<?> nestedType = parameter.getType();
            return this.getParametersFromClass(nestedType, parameterName).toString();
        }
        return parameterName;
    }

    private boolean hasProjectedFieldName(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(ProjectedFieldName.class);
    }

    private String getNameFromProjectedFieldName(AnnotatedElement annotatedElement) {
        String name = annotatedElement.getAnnotation(ProjectedFieldName.class).value();
        if (name.isEmpty()) {
            throw new PanacheQueryException("The annotation ProjectedFieldName must have a non-empty value.");
        }
        return name;
    }

    public void filter(String filterName, Map<String, Object> parameters) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Map<String, Object>>();
        }
        this.filters.put(filterName, parameters);
    }

    public void page(Page page) {
        this.page = page;
        this.range = null;
    }

    public void page(int pageIndex, int pageSize) {
        this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public void nextPage() {
        this.checkPagination();
        this.page(this.page.next());
    }

    public void previousPage() {
        this.checkPagination();
        this.page(this.page.previous());
    }

    public void firstPage() {
        this.checkPagination();
        this.page(this.page.first());
    }

    public Uni<Void> lastPage() {
        this.checkPagination();
        return this.pageCount().map(count -> {
            this.page(this.page.index(count - 1));
            return null;
        });
    }

    public Uni<Boolean> hasNextPage() {
        this.checkPagination();
        return this.pageCount().map(pageCount -> this.page.index < pageCount - 1);
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public Uni<Integer> pageCount() {
        this.checkPagination();
        return this.count().map(count -> {
            if (count == 0L) {
                return 1;
            }
            return (int)Math.ceil((double)count.longValue() / (double)this.page.size);
        });
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public void range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
    }

    public void withLock(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void withHint(String hintName, Object value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, Object>();
        }
        this.hints.put(hintName, value);
        throw new UnsupportedOperationException("Hints not supported yet");
    }

    public Uni<Long> count() {
        String selectQuery = PanacheJpaUtil.isNamedQuery((String)this.query) ? NamedQueryUtil.getNamedQuery(this.query.substring(1)) : this.query;
        if (this.count == null) {
            this.count = this.em.flatMap(session -> {
                Mutiny.Query countQuery = session.createQuery(this.countQuery(selectQuery));
                if (this.paramsArrayOrMap instanceof Map) {
                    AbstractJpaOperations.bindParameters(countQuery, (Map<String, Object>)((Map)this.paramsArrayOrMap));
                } else {
                    AbstractJpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
                }
                return this.applyFilters((Mutiny.Session)session, () -> countQuery.getSingleResult());
            });
        }
        return this.count;
    }

    private String countQuery(String selectQuery) {
        if (this.countQuery != null) {
            return this.countQuery;
        }
        return PanacheJpaUtil.getFastCountQuery((String)selectQuery);
    }

    public <T extends Entity> Uni<List<T>> list() {
        return this.em.flatMap(session -> {
            Mutiny.SelectionQuery<?> jpaQuery = this.createQuery((Mutiny.Session)session);
            return this.applyFilters((Mutiny.Session)session, () -> jpaQuery.getResultList());
        });
    }

    public <T extends Entity> Multi<T> stream() {
        Uni<List<T>> results = this.list();
        return results.toMulti().flatMap(list -> Multi.createFrom().iterable((Iterable)list));
    }

    public <T extends Entity> Uni<T> firstResult() {
        return this.em.flatMap(session -> {
            Mutiny.SelectionQuery<?> jpaQuery = this.createQuery((Mutiny.Session)session, 1);
            return this.applyFilters((Mutiny.Session)session, () -> jpaQuery.getResultList().map(list -> list.isEmpty() ? null : list.get(0)));
        });
    }

    public <T extends Entity> Uni<T> singleResult() {
        return this.em.flatMap(session -> {
            Mutiny.SelectionQuery<?> jpaQuery = this.createQuery((Mutiny.Session)session);
            return this.applyFilters((Mutiny.Session)session, () -> jpaQuery.getSingleResult().map(v -> v)).onFailure(CompletionException.class).transform(t -> t.getCause());
        });
    }

    private Mutiny.SelectionQuery<?> createQuery(Mutiny.Session em) {
        Mutiny.SelectionQuery<?> jpaQuery = this.createBaseQuery(em);
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
            jpaQuery.setMaxResults(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
            jpaQuery.setMaxResults(this.page.size);
        }
        return jpaQuery;
    }

    private Mutiny.SelectionQuery<?> createQuery(Mutiny.Session em, int maxResults) {
        Mutiny.SelectionQuery<?> jpaQuery = this.createBaseQuery(em);
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
        } else {
            jpaQuery.setFirstResult(0);
        }
        jpaQuery.setMaxResults(maxResults);
        return jpaQuery;
    }

    private Mutiny.SelectionQuery<?> createBaseQuery(Mutiny.Session em) {
        Mutiny.SelectionQuery jpaQuery;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            String namedQuery = this.query.substring(1);
            jpaQuery = em.createNamedQuery(namedQuery, this.projectionType);
        } else {
            try {
                jpaQuery = em.createQuery((String)(this.orderBy != null ? this.query + this.orderBy : this.query), this.projectionType);
            }
            catch (IllegalArgumentException x) {
                throw NamedQueryUtil.checkForNamedQueryMistake(x, this.originalQuery);
            }
        }
        if (this.paramsArrayOrMap instanceof Map) {
            AbstractJpaOperations.bindParameters(jpaQuery, (Map<String, Object>)((Map)this.paramsArrayOrMap));
        } else {
            AbstractJpaOperations.bindParameters(jpaQuery, (Object[])this.paramsArrayOrMap);
        }
        if (this.lockModeType != null) {
            jpaQuery.setLockMode(this.lockModeType);
        }
        if (this.hints != null) {
            // empty if block
        }
        return jpaQuery;
    }

    private <T> Uni<T> applyFilters(Mutiny.Session em, Supplier<Uni<T>> uni) {
        if (this.filters == null) {
            return uni.get();
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
            Filter filter = em.enableFilter(entry.getKey());
            for (Map.Entry<String, Object> paramEntry : entry.getValue().entrySet()) {
                filter.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            filter.validate();
        }
        return uni.get().onTermination().invoke(() -> {
            for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
                em.disableFilter(entry.getKey());
            }
        });
    }
}

