/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.runtime.NamedQueryUtil;
import io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.smallrye.mutiny.Uni;
import jakarta.persistence.LockModeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    private static volatile Map<String, String> entityToPersistenceUnit = Collections.emptyMap();
    static final long TIMEOUT_MS = 5000L;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static void setEntityToPersistenceUnit(Map<String, String> map) {
        entityToPersistenceUnit = Collections.unmodifiableMap(map);
    }

    protected abstract PanacheQueryType createPanacheQuery(Uni<Mutiny.Session> var1, String var2, String var3, String var4, Object var5);

    protected abstract Uni<List<?>> list(PanacheQueryType var1);

    public Uni<Void> persist(Object entity) {
        return this.persist(this.getSession(entity.getClass()), entity);
    }

    public Uni<Void> persist(Uni<Mutiny.Session> sessionUni, Object entity) {
        return sessionUni.chain(session -> {
            if (!session.contains(entity)) {
                return session.persist(entity);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public Uni<Void> persist(Iterable<?> entities) {
        ArrayList list = new ArrayList();
        for (Object entity : entities) {
            list.add(entity);
        }
        return this.persist(list.toArray(EMPTY_OBJECT_ARRAY));
    }

    public Uni<Void> persist(Object firstEntity, Object ... entities) {
        ArrayList<Object> list = new ArrayList<Object>(entities.length + 1);
        list.add(firstEntity);
        Collections.addAll(list, entities);
        return this.persist(list.toArray(EMPTY_OBJECT_ARRAY));
    }

    public Uni<Void> persist(Stream<?> entities) {
        return this.persist(entities.toArray());
    }

    public Uni<Void> persist(Object ... entities) {
        Map<String, List<Object>> sessions = Arrays.stream(entities).collect(Collectors.groupingBy(e -> entityToPersistenceUnit.get(e.getClass().getName())));
        ArrayList<Uni> results = new ArrayList<Uni>();
        for (Map.Entry<String, List<Object>> entry : sessions.entrySet()) {
            results.add(this.getSession(entry.getKey()).chain(session -> session.persistAll(((List)entry.getValue()).toArray())));
        }
        return Uni.combine().all().unis(results).discardItems();
    }

    public Uni<Void> delete(Object entity) {
        return this.getSession(entity.getClass()).chain(session -> session.remove(entity));
    }

    public boolean isPersistent(Object entity) {
        Mutiny.Session currentSession = this.getCurrentSession(entity.getClass());
        if (currentSession == null) {
            return false;
        }
        return currentSession.contains(entity);
    }

    public Mutiny.Session getCurrentSession(Class<?> entityClass) {
        String persistenceUnitName = entityToPersistenceUnit.get(entityClass.getName());
        return SessionOperations.getCurrentSession(persistenceUnitName);
    }

    public Uni<Void> flush(Object entity) {
        return this.getSession(entity.getClass()).chain(Mutiny.Session::flush);
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Uni<?> findById(Class<?> entityClass, Object id) {
        return this.getSession(entityClass).chain(session -> session.find(entityClass, id));
    }

    public Uni<?> findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return this.getSession(entityClass).chain(session -> session.find(entityClass, id, LockModeConverter.convertToLockMode((LockModeType)lockModeType)));
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Object ... params) {
        return this.find(entityClass, panacheQuery, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        Uni<Mutiny.Session> session = this.getSession(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, panacheQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        String hqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(session, hqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.find(entityClass, panacheQuery, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        Uni<Mutiny.Session> session = this.getSession(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, panacheQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        String hqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(session, hqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Uni<Mutiny.Session> session = this.getSession(entityClass);
        return this.createPanacheQuery(session, query, null, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Uni<Mutiny.Session> session = this.getSession(entityClass);
        return this.createPanacheQuery(session, query, null, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public Uni<List<?>> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public Uni<List<?>> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Uni<Long> count(Class<?> entityClass) {
        return this.getSession(entityClass).chain(session -> session.createSelectionQuery("FROM " + PanacheJpaUtil.getEntityName((Class)entityClass), entityClass).getResultCount());
    }

    public Uni<Long> count(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName, Long.class), params).getSingleResult();
            });
        }
        return this.getSession(entityClass).chain(session -> AbstractJpaOperations.bindParameters(session.createSelectionQuery(PanacheJpaUtil.createQueryForCount((Class)entityClass, (String)panacheQuery, (int)this.paramCount(params)), Object.class), params).getResultCount()).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Long> count(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName, Long.class), params).getSingleResult();
            });
        }
        return this.getSession(entityClass).chain(session -> AbstractJpaOperations.bindParameters(session.createSelectionQuery(PanacheJpaUtil.createQueryForCount((Class)entityClass, (String)panacheQuery, (int)this.paramCount(params)), Object.class), params).getResultCount()).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Long> count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public Uni<Boolean> exists(Class<?> entityClass) {
        return this.count(entityClass).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Boolean> exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params).map(c -> c > 0L);
    }

    public Uni<Long> deleteAll(Class<?> entityClass) {
        return this.getSession(entityClass).chain(session -> session.createMutationQuery("DELETE FROM " + PanacheJpaUtil.getEntityName((Class)entityClass)).executeUpdate().map(Integer::longValue));
    }

    public Uni<Boolean> deleteById(Class<?> entityClass, Object id) {
        return this.findById(entityClass, id).chain(entity -> {
            if (entity == null) {
                return Uni.createFrom().item((Object)false);
            }
            return this.getSession(entityClass).chain(session -> session.remove(entity).map(v -> true));
        });
    }

    public Uni<Long> delete(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName), params).executeUpdate().map(Integer::longValue);
            });
        }
        return this.getSession(entityClass).chain(session -> AbstractJpaOperations.bindParameters(session.createMutationQuery(PanacheJpaUtil.createDeleteQuery((Class)entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate().map(Integer::longValue)).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Long> delete(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName), params).executeUpdate().map(Integer::longValue);
            });
        }
        return this.getSession(entityClass).chain(session -> AbstractJpaOperations.bindParameters(session.createMutationQuery(PanacheJpaUtil.createDeleteQuery((Class)entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate().map(Integer::longValue)).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName), params).executeUpdate();
            });
        }
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.executeUpdate(updateQuery, params).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Integer> executeUpdate(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return this.getSession(entityClass).chain(session -> {
                String namedQueryName = panacheQuery.substring(1);
                NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
                return AbstractJpaOperations.bindParameters(session.createNamedQuery(namedQueryName), params).executeUpdate();
            });
        }
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.executeUpdate(updateQuery, params).onFailure(RuntimeException.class).transform(x -> NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery));
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public Uni<Integer> update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public Uni<Mutiny.Session> getSession() {
        return this.getSession("<default>");
    }

    public Uni<Mutiny.Session> getSession(Class<?> clazz) {
        String className = clazz.getName();
        String persistenceUnitName = entityToPersistenceUnit.get(className);
        return this.getSession(persistenceUnitName);
    }

    public Uni<Mutiny.Session> getSession(String persistenceUnitName) {
        return SessionOperations.getSession(persistenceUnitName);
    }

    public static Mutiny.Query<?> bindParameters(Mutiny.Query<?> query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static <T extends Mutiny.AbstractQuery> T bindParameters(T query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static <T extends Mutiny.AbstractQuery> T bindParameters(T query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public Uni<Integer> executeUpdate(String query, Object ... params) {
        return this.getSession("<default>").chain(session -> AbstractJpaOperations.bindParameters(session.createMutationQuery(query), params).executeUpdate());
    }

    public Uni<Integer> executeUpdate(String query, Map<String, Object> params) {
        return this.getSession("<default>").chain(session -> AbstractJpaOperations.bindParameters(session.createMutationQuery(query), params).executeUpdate());
    }
}

