/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.hibernate.reactive.panache.deployment.ReactiveJavaJpaTypeBundle;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.visitors.PanacheJpaEntityClassVisitor;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.Transient;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;

public class PanacheJpaEntityEnhancer
extends PanacheEntityEnhancer<MetamodelInfo<EntityModel<EntityField>>> {
    private static final DotName DOTNAME_TRANSIENT = DotName.createSimple((String)Transient.class.getName());

    public PanacheJpaEntityEnhancer(IndexView index, List<PanacheMethodCustomizer> methodCustomizers) {
        super(index, methodCustomizers);
        this.modelInfo = new MetamodelInfo();
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheJpaEntityClassVisitor(outputClassVisitor, this.modelInfo, this.indexView.getClassByName(DotName.createSimple((String)className)), this.methodCustomizers, this.indexView, ReactiveJavaJpaTypeBundle.BUNDLE);
    }

    public void collectFields(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_TRANSIENT)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        this.modelInfo.addEntityModel(entityModel);
    }
}

