/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.reactive.panache.PanacheEntity;
import io.quarkus.hibernate.reactive.panache.PanacheEntityBase;
import io.quarkus.hibernate.reactive.panache.PanacheRepository;
import io.quarkus.hibernate.reactive.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.reactive.panache.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.hibernate.reactive.panache.deployment.PanacheJpaRepositoryEnhancer;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.Id;
import org.hibernate.reactive.mutiny.Mutiny;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class PanacheHibernateResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    private static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    private static final DotName DOTNAME_REACTIVE_SESSION = DotName.createSimple((String)Mutiny.Session.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());
    protected static final String META_INF_PANACHE_ARCHIVE_MARKER = "META-INF/panache-archive.marker";

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_REACTIVE_PANACHE);
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DOTNAME_REACTIVE_SESSION});
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(META_INF_PANACHE_ARCHIVE_MARKER);
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, BuildProducer<PanacheEntityClassesBuildItem> entityClasses, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) throws Exception {
        MetamodelInfo modelInfo;
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        PanacheJpaRepositoryEnhancer daoEnhancer = new PanacheJpaRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || daoEnhancer.skipRepository(classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (daoEnhancer.skipRepository(classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        PanacheJpaEntityEnhancer modelEnhancer = new PanacheJpaEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        for (Object classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_ENTITY) || !modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields((ClassInfo)classInfo);
        }
        for (Object classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY)) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields((ClassInfo)classInfo);
        }
        HashSet<String> modelClassNamesInternal = new HashSet<String>();
        for (String modelClass : modelClasses) {
            modelClassNamesInternal.add(modelClass.replace(".", "/"));
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, modelClass, (BiFunction)((Object)modelEnhancer)));
        }
        if (!modelClasses.isEmpty()) {
            entityClasses.produce((BuildItem)new PanacheEntityClassesBuildItem(modelClasses));
        }
        if ((modelInfo = modelEnhancer.getModelInfo()).hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            QuarkusClassLoader tccl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            List archives = tccl.getElementsWithResource(META_INF_PANACHE_ARCHIVE_MARKER);
            for (ClassPathElement i : archives) {
                for (String res : i.getProvidedResources()) {
                    String cn;
                    if (!res.endsWith(".class") || modelClasses.contains(cn = res.replace("/", ".").substring(0, res.length() - 6))) continue;
                    transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
                }
            }
        }
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + info.name() + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }
}

