/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache;

import io.quarkus.hibernate.reactive.panache.PanacheQuery;
import io.quarkus.hibernate.reactive.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.persistence.LockModeType;

public interface PanacheRepositoryBase<Entity, Id> {
    default public Uni<Void> persist(Entity entity) {
        return JpaOperations.persist(entity);
    }

    default public Uni<Void> persistAndFlush(Entity entity) {
        return JpaOperations.persist(entity).flatMap(v -> JpaOperations.flush()).map(v -> null);
    }

    default public Uni<Void> delete(Entity entity) {
        return JpaOperations.delete(entity);
    }

    default public boolean isPersistent(Entity entity) {
        return JpaOperations.isPersistent(entity);
    }

    default public Uni<Void> flush() {
        return JpaOperations.flush();
    }

    @GenerateBridge
    default public Uni<Entity> findById(Id id) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Entity> findById(Id id, LockModeType lockModeType) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll() {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll(Sort sort) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> listAll() {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<List<Entity>> listAll(Sort sort) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> streamAll(Sort sort) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Multi<Entity> streamAll() {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> count() {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> count(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> count(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> count(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> deleteAll() {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Boolean> deleteById(Id id) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> delete(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> delete(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Long> delete(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    default public Uni<Void> persist(Iterable<Entity> entities) {
        return JpaOperations.persist(entities);
    }

    default public Uni<Void> persist(Stream<Entity> entities) {
        return JpaOperations.persist(entities);
    }

    default public Uni<Void> persist(Entity firstEntity, Entity ... entities) {
        return JpaOperations.persist(firstEntity, entities);
    }

    @GenerateBridge
    default public Uni<Integer> update(String query, Object ... params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Integer> update(String query, Map<String, Object> params) {
        throw JpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Uni<Integer> update(String query, Parameters params) {
        throw JpaOperations.implementationInjectionMissing();
    }
}

