/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache;

import io.quarkus.hibernate.reactive.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations;
import io.quarkus.panache.common.Parameters;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.reactive.mutiny.Mutiny;

public class Panache {
    public static <T> Uni<T> withSession(Supplier<Uni<T>> uniSupplier) {
        return SessionOperations.withSession((T s) -> (Uni)uniSupplier.get());
    }

    public static Uni<Mutiny.Session> getSession() {
        return SessionOperations.getSession();
    }

    public static <T> Uni<T> withTransaction(Supplier<Uni<T>> work) {
        return SessionOperations.withTransaction(() -> (Uni)work.get());
    }

    public static Uni<Integer> executeUpdate(String query, Object ... params) {
        return AbstractJpaOperations.executeUpdate((String)query, (Object[])params);
    }

    public static Uni<Integer> executeUpdate(String query, Map<String, Object> params) {
        return AbstractJpaOperations.executeUpdate((String)query, params);
    }

    public static Uni<Integer> executeUpdate(String query, Parameters params) {
        return AbstractJpaOperations.executeUpdate((String)query, (Map)params.map());
    }

    public static Uni<Void> flush() {
        return Panache.getSession().flatMap(session -> session.flush());
    }

    public static Uni<Mutiny.Transaction> currentTransaction() {
        return Panache.getSession().map(session -> session.currentTransaction());
    }
}

