/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.rest.data.panache.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.reactive.panache.PanacheQuery;
import io.quarkus.hibernate.reactive.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import org.hibernate.reactive.mutiny.Mutiny;

final class EntityDataAccessImplementor
implements DataAccessImplementor {
    private final String entityClassName;

    EntityDataAccessImplementor(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    @Override
    public ResultHandle findById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findById", Uni.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page) {
        ResultHandle query = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findAll", PanacheQuery.class, (Object[])new Object[0]), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort) {
        ResultHandle query = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findAll", PanacheQuery.class, (Object[])new Object[]{Sort.class}), new ResultHandle[]{sort});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", Uni.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    @Override
    public ResultHandle persist(BytecodeCreator creator, ResultHandle entity) {
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"persist", Uni.class, (Object[])new Object[0]), entity, new ResultHandle[0]);
    }

    @Override
    public ResultHandle update(BytecodeCreator creator, ResultHandle entity) {
        ResultHandle uniSession = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"getSession", Uni.class, (Object[])new Object[0]), new ResultHandle[0]);
        return UniImplementor.flatMap((BytecodeCreator)creator, (ResultHandle)uniSession, (String)"Failed to retrieve session", (body, session) -> body.returnValue(body.invokeInterfaceMethod(MethodDescriptor.ofMethod(Mutiny.Session.class, (String)"merge", Uni.class, (Class[])new Class[]{Object.class}), session, new ResultHandle[]{entity})));
    }

    @Override
    public ResultHandle deleteById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"deleteById", Uni.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle pageCount(BytecodeCreator creator, ResultHandle page) {
        ResultHandle query = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findAll", PanacheQuery.class, (Object[])new Object[0]), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"pageCount", Uni.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }
}

