/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.rest.data.panache.deployment;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.reactive.panache.common.WithSession;
import io.quarkus.hibernate.reactive.panache.common.WithTransaction;
import io.quarkus.hibernate.reactive.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.hibernate.reactive.rest.data.panache.deployment.EntityClassHelper;
import io.quarkus.hibernate.reactive.rest.data.panache.deployment.HibernateReactiveResourceMethodListenerImplementor;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.runtime.util.HashUtil;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

class ResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(ResourceImplementor.class);
    private final EntityClassHelper entityClassHelper;

    ResourceImplementor(EntityClassHelper entityClassHelper) {
        this.entityClassHelper = entityClassHelper;
    }

    String implement(ClassOutput classOutput, DataAccessImplementor dataAccessImplementor, String resourceType, String entityType, List<ClassInfo> resourceMethodListeners) {
        String className = resourceType + "Impl_" + HashUtil.sha1((String)resourceType);
        LOGGER.tracef("Starting generation of '%s'", (Object)className);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(className).interfaces(new String[]{resourceType}).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        classCreator.addAnnotation(Alternative.class);
        classCreator.addAnnotation(Priority.class).add("value", (Object)Integer.MAX_VALUE);
        HibernateReactiveResourceMethodListenerImplementor resourceMethodListenerImplementor = new HibernateReactiveResourceMethodListenerImplementor(classCreator, resourceMethodListeners);
        this.implementList(classCreator, dataAccessImplementor);
        this.implementListWithQuery(classCreator, dataAccessImplementor);
        this.implementListPageCount(classCreator, dataAccessImplementor);
        this.implementCount(classCreator, dataAccessImplementor);
        this.implementGet(classCreator, dataAccessImplementor);
        this.implementAdd(classCreator, dataAccessImplementor, resourceMethodListenerImplementor);
        this.implementUpdate(classCreator, dataAccessImplementor, entityType, resourceMethodListenerImplementor);
        this.implementDelete(classCreator, dataAccessImplementor, resourceMethodListenerImplementor);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)className);
        return className;
    }

    private void implementList(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", Uni.class, new Class[]{Page.class, Sort.class});
        methodCreator.addAnnotation(WithSession.class);
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle columns = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"getColumns", List.class, (Class[])new Class[0]), sort, new ResultHandle[0]);
        ResultHandle isEmptySort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BranchResult isEmptySortBranch = methodCreator.ifTrue(isEmptySort);
        isEmptySortBranch.trueBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.trueBranch(), page));
        isEmptySortBranch.falseBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.falseBranch(), page, sort));
        methodCreator.close();
    }

    private void implementListWithQuery(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", Uni.class, new Class[]{Page.class, Sort.class, String.class, Map.class});
        methodCreator.addAnnotation(WithSession.class);
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle query = methodCreator.getMethodParam(2);
        ResultHandle queryParams = methodCreator.getMethodParam(3);
        ResultHandle columns = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"getColumns", List.class, (Class[])new Class[0]), sort, new ResultHandle[0]);
        ResultHandle isEmptySort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BranchResult isEmptySortBranch = methodCreator.ifTrue(isEmptySort);
        isEmptySortBranch.trueBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.trueBranch(), page, query, queryParams));
        isEmptySortBranch.falseBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.falseBranch(), page, sort, query, queryParams));
        methodCreator.close();
    }

    private void implementCount(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("count", Uni.class, new Class[0]);
        methodCreator.addAnnotation(WithSession.class);
        methodCreator.returnValue(dataAccessImplementor.count((BytecodeCreator)methodCreator));
        methodCreator.close();
    }

    private void implementListPageCount(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Uni.class, new Class[]{Page.class});
        methodCreator.addAnnotation(WithSession.class);
        ResultHandle page = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.pageCount((BytecodeCreator)methodCreator, page));
        methodCreator.close();
    }

    private void implementGet(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("get", Uni.class, new Class[]{Object.class});
        methodCreator.addAnnotation(WithSession.class);
        ResultHandle id = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.findById((BytecodeCreator)methodCreator, id));
        methodCreator.close();
    }

    private void implementAdd(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, HibernateReactiveResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("add", Uni.class, new Class[]{Object.class});
        methodCreator.addAnnotation(WithTransaction.class);
        ResultHandle entity = methodCreator.getMethodParam(0);
        resourceMethodListenerImplementor.onBeforeAdd((BytecodeCreator)methodCreator, entity);
        ResultHandle uni = dataAccessImplementor.persist((BytecodeCreator)methodCreator, entity);
        uni = resourceMethodListenerImplementor.onAfterAdd((BytecodeCreator)methodCreator, uni);
        methodCreator.returnValue(uni);
        methodCreator.close();
    }

    private void implementUpdate(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, String entityType, HibernateReactiveResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("update", Uni.class, new Class[]{Object.class, Object.class});
        methodCreator.addAnnotation(WithTransaction.class);
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        this.setId((BytecodeCreator)methodCreator, entityType, entity, id);
        resourceMethodListenerImplementor.onBeforeUpdate((BytecodeCreator)methodCreator, entity);
        ResultHandle uni = dataAccessImplementor.update((BytecodeCreator)methodCreator, entity);
        uni = resourceMethodListenerImplementor.onAfterUpdate((BytecodeCreator)methodCreator, uni);
        methodCreator.returnValue(uni);
        methodCreator.close();
    }

    private void implementDelete(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, HibernateReactiveResourceMethodListenerImplementor resourceMethodListenerImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Uni.class, new Class[]{Object.class});
        methodCreator.addAnnotation(WithTransaction.class);
        ResultHandle id = methodCreator.getMethodParam(0);
        resourceMethodListenerImplementor.onBeforeDelete((BytecodeCreator)methodCreator, id);
        ResultHandle uni = dataAccessImplementor.deleteById((BytecodeCreator)methodCreator, id);
        uni = resourceMethodListenerImplementor.onAfterDelete((BytecodeCreator)methodCreator, uni, id);
        methodCreator.returnValue(uni);
        methodCreator.close();
    }

    private void setId(BytecodeCreator creator, String entityType, ResultHandle entity, ResultHandle id) {
        FieldInfo idField = this.entityClassHelper.getIdField(entityType);
        MethodDescriptor idSetter = this.entityClassHelper.getSetter(entityType, idField);
        creator.invokeVirtualMethod(idSetter, entity, new ResultHandle[]{id});
    }
}

