/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.rest.data.panache.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.ResourceMethodListenerImplementor;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public class HibernateReactiveResourceMethodListenerImplementor
extends ResourceMethodListenerImplementor {
    public HibernateReactiveResourceMethodListenerImplementor(ClassCreator cc, List<ClassInfo> resourceMethodListeners) {
        super(cc, resourceMethodListeners);
    }

    public ResultHandle onAfterAdd(BytecodeCreator methodCreator, ResultHandle uni) {
        return this.invokeUniMethodUsingEntity("onAfterAdd", methodCreator, uni);
    }

    public ResultHandle onAfterUpdate(BytecodeCreator methodCreator, ResultHandle uni) {
        return this.invokeUniMethodUsingEntity("onAfterUpdate", methodCreator, uni);
    }

    public ResultHandle onAfterDelete(BytecodeCreator methodCreator, ResultHandle uni, ResultHandle id) {
        return this.invokeUniMethodUsingId("onAfterDelete", methodCreator, uni, id);
    }

    protected ResultHandle invokeUniMethodUsingEntity(String methodName, BytecodeCreator methodCreator, ResultHandle uni) {
        if (!this.hasListenerForMethod(methodName)) {
            return uni;
        }
        return UniImplementor.invoke((BytecodeCreator)methodCreator, (ResultHandle)uni, (lambda, item) -> this.processEventListener(methodName, (BytecodeCreator)lambda, methodCreator.getThis(), (ResultHandle)item));
    }

    protected ResultHandle invokeUniMethodUsingId(String methodName, BytecodeCreator methodCreator, ResultHandle uni, ResultHandle id) {
        if (!this.hasListenerForMethod(methodName)) {
            return uni;
        }
        return UniImplementor.invoke((BytecodeCreator)methodCreator, (ResultHandle)uni, (lambda, voidItem) -> this.processEventListener(methodName, (BytecodeCreator)lambda, methodCreator.getThis(), id));
    }

    private boolean hasListenerForMethod(String methodName) {
        for (Map.Entry eventListenerEntry : this.listenerFields.entrySet()) {
            MethodInfo method = this.findMethodByName((ClassInfo)eventListenerEntry.getValue(), methodName);
            if (method == null) continue;
            return true;
        }
        return false;
    }
}

