/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.FastBootHibernatePersistenceProvider;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrations;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.reactive.runtime.boot.FastBootReactiveEntityManagerFactoryBuilder;
import io.quarkus.hibernate.reactive.runtime.boot.registry.PreconfiguredReactiveServiceRegistryBuilder;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusReactiveConnectionPoolInitiator;
import io.vertx.sqlclient.Pool;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.reactive.provider.service.ReactiveGenerationTarget;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.jboss.logging.Logger;

public final class FastBootHibernateReactivePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(FastBootHibernateReactivePersistenceProvider.class);
    public static final String IMPLEMENTATION_NAME = "org.hibernate.reactive.provider.ReactivePersistenceProvider";
    private final FastBootHibernatePersistenceProvider delegate = new FastBootHibernatePersistenceProvider();

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        if (properties == null) {
            properties = new HashMap();
        }
        try {
            List units = PersistenceUnitsHolder.getPersistenceUnitDescriptors();
            for (PersistenceUnitDescriptor unit : units) {
                if (!IMPLEMENTATION_NAME.equalsIgnoreCase(unit.getProviderClassName()) && unit.getProviderClassName() != null) continue;
                EntityManagerFactoryBuilder emfBuilder = this.getEntityManagerFactoryBuilderOrNull(emName, properties);
                EntityManagerFactory emf = emfBuilder.build();
                return emf;
            }
            return null;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to build EntityManagerFactory", (Throwable)e);
        }
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", (Object)persistenceUnitName);
        this.verifyProperties(properties);
        List units = PersistenceUnitsHolder.getPersistenceUnitDescriptors();
        log.debugf("Located %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (PersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnit.getProviderClassName(), (Object)persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debugf("Excluding from consideration '%s' due to name mis-match", (Object)persistenceUnit.getName());
                continue;
            }
            if (!this.isProvider(persistenceUnit)) {
                log.debug((Object)"Excluding from consideration due to provider mis-match");
                continue;
            }
            RecordedState recordedState = PersistenceUnitsHolder.getRecordedState((String)persistenceUnitName);
            PrevalidatedQuarkusMetadata metadata = recordedState.getMetadata();
            BuildTimeSettings buildTimeSettings = recordedState.getBuildTimeSettings();
            IntegrationSettings integrationSettings = recordedState.getIntegrationSettings();
            RuntimeSettings.Builder runtimeSettingsBuilder = new RuntimeSettings.Builder(buildTimeSettings, integrationSettings);
            HibernateOrmIntegrations.contributeRuntimeProperties((k, v) -> runtimeSettingsBuilder.put(k, v));
            RuntimeSettings runtimeSettings = runtimeSettingsBuilder.build();
            StandardServiceRegistry standardServiceRegistry = this.rewireMetadataAndExtractServiceRegistry(runtimeSettings, recordedState, persistenceUnitName);
            BeanManager cdiBeanManager = Arc.container().beanManager();
            Object validatorFactory = Arc.container().instance("quarkus-hibernate-validator-factory").get();
            return new FastBootReactiveEntityManagerFactoryBuilder(metadata, persistenceUnitName, standardServiceRegistry, runtimeSettings, validatorFactory, cdiBeanManager, recordedState.getMultiTenancyStrategy());
        }
        log.debug((Object)"Found no matching persistence units");
        return null;
    }

    private StandardServiceRegistry rewireMetadataAndExtractServiceRegistry(RuntimeSettings runtimeSettings, RecordedState rs, String persistenceUnitName) {
        PreconfiguredReactiveServiceRegistryBuilder serviceRegistryBuilder = new PreconfiguredReactiveServiceRegistryBuilder(rs);
        this.registerVertxPool(persistenceUnitName, runtimeSettings, serviceRegistryBuilder);
        runtimeSettings.getSettings().forEach((key, value) -> serviceRegistryBuilder.applySetting((String)key, value));
        for (ProvidedService providedService : rs.getProvidedServices()) {
            serviceRegistryBuilder.addService(providedService);
        }
        StandardServiceRegistryImpl standardServiceRegistry = serviceRegistryBuilder.buildNewServiceRegistry();
        ((SchemaManagementTool)standardServiceRegistry.getService(SchemaManagementTool.class)).setCustomDatabaseGenerationTarget((GenerationTarget)new ReactiveGenerationTarget((ServiceRegistry)standardServiceRegistry));
        return standardServiceRegistry;
    }

    private void verifyProperties(Map properties) {
        if (properties != null && properties.size() != 0) {
            throw new PersistenceException("The FastbootHibernateProvider PersistenceProvider can not support runtime provided properties. Make sure you set all properties you need in the configuration resources before building the application.");
        }
    }

    private boolean isProvider(PersistenceUnitDescriptor persistenceUnit) {
        Map props = Collections.emptyMap();
        String requestedProviderName = FastBootHibernatePersistenceProvider.extractRequestedProviderName((PersistenceUnitDescriptor)persistenceUnit, props);
        if (requestedProviderName == null) {
            return true;
        }
        return FastBootHibernateReactivePersistenceProvider.class.getName().equals(requestedProviderName) || IMPLEMENTATION_NAME.equals(requestedProviderName) || FastBootHibernatePersistenceProvider.class.getName().equals(requestedProviderName) || "org.hibernate.jpa.HibernatePersistenceProvider".equals(requestedProviderName);
    }

    private void registerVertxPool(String persistenceUnitName, RuntimeSettings runtimeSettings, PreconfiguredReactiveServiceRegistryBuilder serviceRegistry) {
        if (runtimeSettings.isConfigured("hibernate.connection.url")) {
            return;
        }
        InstanceHandle poolHandle = Arc.container().instance(Pool.class, new Annotation[0]);
        if (!poolHandle.isAvailable()) {
            throw new IllegalStateException("No pool has been defined for persistence unit " + persistenceUnitName);
        }
        serviceRegistry.addInitiator(new QuarkusReactiveConnectionPoolInitiator((Pool)poolHandle.get()));
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        return this.delegate.createContainerEntityManagerFactory(info, map);
    }

    public ProviderUtil getProviderUtil() {
        return this.delegate.getProviderUtil();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        this.delegate.generateSchema(info, map);
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        return this.delegate.generateSchema(persistenceUnitName, map);
    }
}

