/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.boot.registry;

import io.quarkus.hibernate.orm.runtime.boot.registry.MirroringIntegratorService;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusManagedBeanRegistryInitiator;
import io.quarkus.hibernate.orm.runtime.customized.DisabledBytecodeProviderInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusJndiServiceInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusRuntimeProxyFactoryFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.orm.runtime.service.CfgXmlAccessServiceInitiatorQuarkus;
import io.quarkus.hibernate.orm.runtime.service.DisabledJMXInitiator;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRegionFactoryInitiator;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusNoJdbcConnectionProviderInitiator;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusNoJdbcEnvironmentInitiator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderInitiator;
import org.hibernate.engine.jdbc.connections.internal.MultiTenantConnectionProviderInitiator;
import org.hibernate.engine.jdbc.cursor.internal.RefCursorSupportInitiator;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.event.internal.EntityCopyObserverFactoryInitiator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.persister.internal.PersisterFactoryInitiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyResolverInitiator;
import org.hibernate.reactive.context.impl.VertxContextInitiator;
import org.hibernate.reactive.id.impl.ReactiveIdentifierGeneratorFactoryInitiator;
import org.hibernate.reactive.provider.service.NoJtaPlatformInitiator;
import org.hibernate.reactive.provider.service.ReactiveMarkerServiceInitiator;
import org.hibernate.reactive.provider.service.ReactivePersisterClassResolverInitiator;
import org.hibernate.reactive.provider.service.ReactiveQueryTranslatorFactoryInitiator;
import org.hibernate.reactive.provider.service.ReactiveSessionFactoryBuilderInitiator;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.SessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractorInitiator;
import org.hibernate.tool.schema.internal.SchemaManagementToolInitiator;

public class PreconfiguredReactiveServiceRegistryBuilder {
    private final Map configurationValues = new HashMap();
    private final List<StandardServiceInitiator> initiators;
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private final Collection<Integrator> integrators;
    private final StandardServiceRegistryImpl destroyedRegistry;

    public PreconfiguredReactiveServiceRegistryBuilder(RecordedState rs) {
        PreconfiguredReactiveServiceRegistryBuilder.checkIsReactive(rs);
        this.initiators = PreconfiguredReactiveServiceRegistryBuilder.buildQuarkusServiceInitiatorList(rs);
        this.integrators = rs.getIntegrators();
        this.destroyedRegistry = (StandardServiceRegistryImpl)rs.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    private static void checkIsReactive(RecordedState rs) {
        if (!rs.isReactive()) {
            throw new IllegalStateException("Booting an Hibernate Reactive serviceregistry on a non-reactive RecordedState!");
        }
    }

    public PreconfiguredReactiveServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.configurationValues.put(settingName, value);
        return this;
    }

    public PreconfiguredReactiveServiceRegistryBuilder addInitiator(StandardServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public PreconfiguredReactiveServiceRegistryBuilder addService(ProvidedService providedService) {
        this.providedServices.add(providedService);
        return this;
    }

    public StandardServiceRegistryImpl buildNewServiceRegistry() {
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildEmptyBootstrapServiceRegistry();
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.configurationValues);
        this.destroyedRegistry.resetAndReactivate(bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
        return this.destroyedRegistry;
    }

    private BootstrapServiceRegistry buildEmptyBootstrapServiceRegistry() {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(FlatClassLoaderService.INSTANCE);
        return new BootstrapServiceRegistryImpl(true, FlatClassLoaderService.INSTANCE, (StrategySelector)strategySelector, (IntegratorService)new MirroringIntegratorService(this.integrators));
    }

    private static List<StandardServiceInitiator> buildQuarkusServiceInitiatorList(RecordedState rs) {
        ArrayList<StandardServiceInitiator> serviceInitiators = new ArrayList<StandardServiceInitiator>();
        serviceInitiators.add((StandardServiceInitiator)ReactiveMarkerServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)VertxContextInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ReactiveSessionFactoryBuilderInitiator.INSTANCE);
        serviceInitiators.add(DisabledBytecodeProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)new QuarkusRuntimeProxyFactoryFactoryInitiator(rs));
        serviceInitiators.add((StandardServiceInitiator)CfgXmlAccessServiceInitiatorQuarkus.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PropertyAccessStrategyResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ImportSqlCommandExtractorInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)SchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)new QuarkusNoJdbcEnvironmentInitiator(rs.getDialect()));
        serviceInitiators.add((StandardServiceInitiator)QuarkusJndiServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)DisabledJMXInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ReactivePersisterClassResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PersisterFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusNoJdbcConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)MultiTenantConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)BatchBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)JdbcServicesInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)RefCursorSupportInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ReactiveQueryTranslatorFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)NoJtaPlatformInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)SessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)QuarkusRegionFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)TransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)QuarkusManagedBeanRegistryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)EntityCopyObserverFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ReactiveIdentifierGeneratorFactoryInitiator.INSTANCE);
        serviceInitiators.trimToSize();
        return serviceInitiators;
    }
}

