/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.customized;

import io.vertx.sqlclient.Pool;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.ExternalSqlClientPool;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class QuarkusReactiveConnectionPoolInitiator
implements StandardServiceInitiator<ReactiveConnectionPool> {
    private final Pool pool;

    public QuarkusReactiveConnectionPoolInitiator(Pool pool) {
        this.pool = pool;
    }

    public Class<ReactiveConnectionPool> getServiceInitiated() {
        return ReactiveConnectionPool.class;
    }

    public ReactiveConnectionPool initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)configurationValues);
        if (strategy == MultiTenancyStrategy.DATABASE || strategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        boolean usePostgresStyleParameters = ((JdbcEnvironment)registry.getService(JdbcEnvironment.class)).getDialect() instanceof PostgreSQL9Dialect;
        SqlStatementLogger sqlStatementLogger = ((JdbcServices)registry.getService(JdbcServices.class)).getSqlStatementLogger();
        return new ExternalSqlClientPool(this.pool, sqlStatementLogger, usePostgresStyleParameters);
    }
}

