/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.customized;

import io.vertx.sqlclient.Pool;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.SqlClientPool;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class QuarkusReactiveConnectionPoolInitiator
implements StandardServiceInitiator<ReactiveConnectionPool> {
    private final Pool pool;

    public QuarkusReactiveConnectionPoolInitiator(Pool pool) {
        this.pool = pool;
    }

    public Class<ReactiveConnectionPool> getServiceInitiated() {
        return ReactiveConnectionPool.class;
    }

    public ReactiveConnectionPool initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)configurationValues);
        if (strategy == MultiTenancyStrategy.DATABASE || strategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        SqlStatementLogger sqlStatementLogger = ((JdbcServices)registry.getService(JdbcServices.class)).getSqlStatementLogger();
        return new ExternalSqlClientPool(this.pool, sqlStatementLogger);
    }

    private static class ExternalSqlClientPool
    extends SqlClientPool {
        private final Pool pool;
        private final SqlStatementLogger sqlStatementLogger;

        public ExternalSqlClientPool(Pool pool, SqlStatementLogger sqlStatementLogger) {
            this.pool = pool;
            this.sqlStatementLogger = sqlStatementLogger;
        }

        protected Pool getPool() {
            return this.pool;
        }

        protected SqlStatementLogger getSqlStatementLogger() {
            return this.sqlStatementLogger;
        }

        public CompletionStage<Void> getCloseFuture() {
            return CompletionStages.voidFuture();
        }
    }
}

