/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.common.spi.MutinyImplementor;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;

public class ReactiveSessionFactoryProducer {
    @Inject
    @PersistenceUnit
    EntityManagerFactory emf;
    @Inject
    JPAConfig jpaConfig;

    @Produces
    @ApplicationScoped
    @DefaultBean
    @Unremovable
    @Typed(value={Mutiny.SessionFactory.class, MutinyImplementor.class, Implementor.class})
    public MutinySessionFactoryImpl mutinySessionFactory() {
        if (this.jpaConfig.getDeactivatedPersistenceUnitNames().contains("default-reactive")) {
            throw new IllegalStateException("Cannot retrieve the Mutiny.SessionFactory for persistence unit default-reactive: Hibernate Reactive was deactivated through configuration properties");
        }
        return (MutinySessionFactoryImpl)this.emf.unwrap(Mutiny.SessionFactory.class);
    }
}

