/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.FastBootHibernatePersistenceProvider;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.reactive.runtime.boot.FastBootReactiveEntityManagerFactoryBuilder;
import io.quarkus.hibernate.reactive.runtime.boot.registry.PreconfiguredReactiveServiceRegistryBuilder;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusReactiveConnectionPoolInitiator;
import io.quarkus.hibernate.reactive.runtime.customized.VertxInstanceInitiator;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.ProviderUtil;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.reactive.provider.service.ReactiveGenerationTarget;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.jboss.logging.Logger;

public final class FastBootHibernateReactivePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(FastBootHibernateReactivePersistenceProvider.class);
    public static final String IMPLEMENTATION_NAME = "org.hibernate.reactive.provider.ReactivePersistenceProvider";
    private final ProviderUtil providerUtil = new io.quarkus.hibernate.orm.runtime.ProviderUtil();
    private volatile FastBootHibernatePersistenceProvider delegate;
    private final HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig;
    private final Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors;

    public FastBootHibernateReactivePersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        this.hibernateOrmRuntimeConfig = hibernateOrmRuntimeConfig;
        this.integrationRuntimeDescriptors = integrationRuntimeDescriptors;
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        if (properties == null) {
            properties = new HashMap();
        }
        List<QuarkusPersistenceUnitDescriptor> units = PersistenceUnitsHolder.getPersistenceUnitDescriptors().stream().filter(u -> u.getName().equals(emName)).filter(u -> u.isReactive()).toList();
        for (QuarkusPersistenceUnitDescriptor unit : units) {
            if (!IMPLEMENTATION_NAME.equalsIgnoreCase(unit.getProviderClassName()) && unit.getProviderClassName() != null) continue;
            EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(emName, properties);
            if (builder == null) {
                log.trace((Object)"Could not obtain matching EntityManagerFactoryBuilder, returning null");
                return null;
            }
            return builder.build();
        }
        return null;
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", (Object)persistenceUnitName);
        this.verifyProperties(properties);
        List<QuarkusPersistenceUnitDescriptor> units = PersistenceUnitsHolder.getPersistenceUnitDescriptors().stream().filter(d -> d.isReactive()).toList();
        log.debugf("Located %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (QuarkusPersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnit.getProviderClassName(), (Object)persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debugf("Excluding from consideration '%s' due to name mismatch", (Object)persistenceUnit.getName());
                continue;
            }
            if (!this.isProvider((PersistenceUnitDescriptor)persistenceUnit)) {
                log.debug((Object)"Excluding from consideration due to provider mismatch");
                continue;
            }
            RecordedState recordedState = PersistenceUnitsHolder.popRecordedState((String)persistenceUnitName);
            PrevalidatedQuarkusMetadata metadata = recordedState.getMetadata();
            BuildTimeSettings buildTimeSettings = recordedState.getBuildTimeSettings();
            IntegrationSettings integrationSettings = recordedState.getIntegrationSettings();
            RuntimeSettings.Builder runtimeSettingsBuilder = new RuntimeSettings.Builder(buildTimeSettings, integrationSettings);
            HibernateOrmRuntimeConfigPersistenceUnit puConfig = (HibernateOrmRuntimeConfigPersistenceUnit)this.hibernateOrmRuntimeConfig.persistenceUnits().get(persistenceUnit.getConfigurationName());
            if (puConfig.active().isPresent() && !((Boolean)puConfig.active().get()).booleanValue()) {
                throw new IllegalStateException("Attempting to boot a deactivated Hibernate Reactive persistence unit");
            }
            if (!recordedState.isFromPersistenceXml()) {
                FastBootHibernateReactivePersistenceProvider.injectRuntimeConfiguration(puConfig, runtimeSettingsBuilder);
            }
            for (HibernateOrmIntegrationRuntimeDescriptor hibernateOrmIntegrationRuntimeDescriptor : this.integrationRuntimeDescriptors.getOrDefault(persistenceUnitName, Collections.emptyList())) {
                Optional listenerOptional = hibernateOrmIntegrationRuntimeDescriptor.getInitListener();
                if (!listenerOptional.isPresent()) continue;
                ((HibernateOrmIntegrationRuntimeInitListener)listenerOptional.get()).contributeRuntimeProperties((arg_0, arg_1) -> ((RuntimeSettings.Builder)runtimeSettingsBuilder).put(arg_0, arg_1));
            }
            if (!puConfig.unsupportedProperties().isEmpty()) {
                log.warnf("Persistence-unit [%s] sets unsupported properties. These properties may not work correctly, and even if they do, that may change when upgrading to a newer version of Quarkus (even just a micro/patch version). Consider using a supported configuration property before falling back to unsupported ones. If there is no supported equivalent, make sure to file a feature request so that a supported configuration property can be added to Quarkus, and more importantly so that the configuration property is tested regularly. Unsupported properties being set: %s", (Object)persistenceUnitName, puConfig.unsupportedProperties().keySet());
            }
            for (Map.Entry entry : puConfig.unsupportedProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (runtimeSettingsBuilder.get(key) != null) {
                    log.warnf("Persistence-unit [%s] sets property '%s' to a custom value through '%s', but Quarkus already set that property independently. The custom value will be ignored.", (Object)persistenceUnitName, (Object)key, (Object)HibernateOrmRuntimeConfig.puPropertyKey((String)persistenceUnit.getConfigurationName(), (String)("unsupported-properties.\"" + key + "\"")));
                    continue;
                }
                runtimeSettingsBuilder.put((String)entry.getKey(), entry.getValue());
            }
            RuntimeSettings runtimeSettings = runtimeSettingsBuilder.build();
            StandardServiceRegistry standardServiceRegistry = this.rewireMetadataAndExtractServiceRegistry(persistenceUnitName, recordedState, runtimeSettings, puConfig);
            BeanManager cdiBeanManager = Arc.container().beanManager();
            Object validatorFactory = Arc.container().instance("quarkus-hibernate-validator-factory").get();
            return new FastBootReactiveEntityManagerFactoryBuilder(persistenceUnit, metadata, standardServiceRegistry, runtimeSettings, validatorFactory, cdiBeanManager, recordedState.getMultiTenancyStrategy(), PersistenceUnitsHolder.getPersistenceUnitDescriptors().size() == 1);
        }
        log.debug((Object)"Found no matching persistence units");
        return null;
    }

    private StandardServiceRegistry rewireMetadataAndExtractServiceRegistry(String persistenceUnitName, RecordedState rs, RuntimeSettings runtimeSettings, HibernateOrmRuntimeConfigPersistenceUnit puConfig) {
        PreconfiguredReactiveServiceRegistryBuilder serviceRegistryBuilder = new PreconfiguredReactiveServiceRegistryBuilder(persistenceUnitName, rs, puConfig);
        this.registerVertxAndPool(persistenceUnitName, runtimeSettings, serviceRegistryBuilder);
        runtimeSettings.getSettings().forEach((key, value) -> serviceRegistryBuilder.applySetting((String)key, value));
        HashSet<Class> runtimeInitiatedServiceClasses = new HashSet<Class>();
        for (HibernateOrmIntegrationRuntimeDescriptor descriptor : this.integrationRuntimeDescriptors.getOrDefault(persistenceUnitName, Collections.emptyList())) {
            Optional listenerOptional = descriptor.getInitListener();
            if (!listenerOptional.isPresent()) continue;
            for (StandardServiceInitiator serviceInitiator : ((HibernateOrmIntegrationRuntimeInitListener)listenerOptional.get()).contributeServiceInitiators()) {
                Class serviceClass = serviceInitiator.getServiceInitiated();
                runtimeInitiatedServiceClasses.add(serviceClass);
                serviceRegistryBuilder.addInitiator(serviceInitiator);
            }
        }
        for (ProvidedService providedService : rs.getProvidedServices()) {
            if (runtimeInitiatedServiceClasses.contains(providedService.getServiceRole())) continue;
            serviceRegistryBuilder.addService(providedService);
        }
        StandardServiceRegistryImpl standardServiceRegistry = serviceRegistryBuilder.buildNewServiceRegistry();
        ((SchemaManagementTool)standardServiceRegistry.getService(SchemaManagementTool.class)).setCustomDatabaseGenerationTarget((GenerationTarget)new ReactiveGenerationTarget((ServiceRegistry)standardServiceRegistry));
        return standardServiceRegistry;
    }

    private void verifyProperties(Map properties) {
        if (properties != null && properties.size() != 0) {
            throw new PersistenceException("The FastbootHibernateProvider PersistenceProvider can not support runtime provided properties. Make sure you set all properties you need in the configuration resources before building the application.");
        }
    }

    private boolean isProvider(PersistenceUnitDescriptor persistenceUnit) {
        Map props = Collections.emptyMap();
        String requestedProviderName = FastBootHibernatePersistenceProvider.extractRequestedProviderName((PersistenceUnitDescriptor)persistenceUnit, props);
        if (requestedProviderName == null) {
            return true;
        }
        return FastBootHibernateReactivePersistenceProvider.class.getName().equals(requestedProviderName) || IMPLEMENTATION_NAME.equals(requestedProviderName) || FastBootHibernatePersistenceProvider.class.getName().equals(requestedProviderName) || "org.hibernate.jpa.HibernatePersistenceProvider".equals(requestedProviderName);
    }

    private void registerVertxAndPool(String persistenceUnitName, RuntimeSettings runtimeSettings, PreconfiguredReactiveServiceRegistryBuilder serviceRegistry) {
        Pool pool;
        if (runtimeSettings.isConfigured("hibernate.connection.url")) {
            return;
        }
        String datasourceName = "<default>";
        try {
            InjectableInstance poolHandle = Arc.container().select(Pool.class, new Annotation[0]);
            if (!poolHandle.isResolvable()) {
                throw new IllegalStateException("No pool has been defined for persistence unit " + persistenceUnitName);
            }
            pool = (Pool)ClientProxy.unwrap((Object)((Pool)poolHandle.get()));
        }
        catch (RuntimeException e) {
            throw PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)datasourceName, (Throwable)e);
        }
        serviceRegistry.addInitiator(new QuarkusReactiveConnectionPoolInitiator(pool));
        InstanceHandle vertxHandle = Arc.container().instance(Vertx.class, new Annotation[0]);
        if (!vertxHandle.isAvailable()) {
            throw new IllegalStateException("No Vert.x instance has been registered in ArC ?");
        }
        serviceRegistry.addInitiator(new VertxInstanceInitiator((Vertx)vertxHandle.get()));
    }

    private static void injectRuntimeConfiguration(HibernateOrmRuntimeConfigPersistenceUnit persistenceUnitConfig, RuntimeSettings.Builder runtimeSettingsBuilder) {
        runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.database.action", (Object)persistenceUnitConfig.database().generation().generation());
        runtimeSettingsBuilder.put("jakarta.persistence.create-database-schemas", (Object)String.valueOf(persistenceUnitConfig.database().generation().createSchemas()));
        if (persistenceUnitConfig.database().generation().haltOnError()) {
            runtimeSettingsBuilder.put("hibernate.hbm2ddl.halt_on_error", (Object)"true");
        }
        runtimeSettingsBuilder.put("hibernate.hbm2ddl.schema-generation.script.append", (Object)"false");
        runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.scripts.action", (Object)persistenceUnitConfig.scripts().generation().generation());
        if (persistenceUnitConfig.scripts().generation().createTarget().isPresent()) {
            runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.scripts.create-target", persistenceUnitConfig.scripts().generation().createTarget().get());
        }
        if (persistenceUnitConfig.scripts().generation().dropTarget().isPresent()) {
            runtimeSettingsBuilder.put("jakarta.persistence.schema-generation.scripts.drop-target", persistenceUnitConfig.scripts().generation().dropTarget().get());
        }
        persistenceUnitConfig.database().defaultCatalog().ifPresent(catalog -> runtimeSettingsBuilder.put("hibernate.default_catalog", catalog));
        persistenceUnitConfig.database().defaultSchema().ifPresent(schema -> runtimeSettingsBuilder.put("hibernate.default_schema", schema));
        if (persistenceUnitConfig.log().sql()) {
            runtimeSettingsBuilder.put("hibernate.show_sql", (Object)"true");
            if (persistenceUnitConfig.log().formatSql()) {
                runtimeSettingsBuilder.put("hibernate.format_sql", (Object)"true");
            }
            if (persistenceUnitConfig.log().highlightSql()) {
                runtimeSettingsBuilder.put("hibernate.highlight_sql", (Object)"true");
            }
        }
        if (persistenceUnitConfig.log().jdbcWarnings().isPresent()) {
            runtimeSettingsBuilder.put("hibernate.jdbc.log.warnings", (Object)((Boolean)persistenceUnitConfig.log().jdbcWarnings().get()).toString());
        }
        if (persistenceUnitConfig.log().queriesSlowerThanMs().isPresent()) {
            runtimeSettingsBuilder.put("hibernate.log_slow_query", persistenceUnitConfig.log().queriesSlowerThanMs().get());
        }
        runtimeSettingsBuilder.put("org.hibernate.flushMode", (Object)persistenceUnitConfig.flush().mode());
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        return this.getJdbcHibernatePersistenceProviderDelegate().createContainerEntityManagerFactory(info, map);
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        this.getJdbcHibernatePersistenceProviderDelegate().generateSchema(info, map);
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        return this.getJdbcHibernatePersistenceProviderDelegate().generateSchema(persistenceUnitName, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastBootHibernatePersistenceProvider getJdbcHibernatePersistenceProviderDelegate() {
        FastBootHibernatePersistenceProvider localDelegate = this.delegate;
        if (localDelegate == null) {
            FastBootHibernateReactivePersistenceProvider fastBootHibernateReactivePersistenceProvider = this;
            synchronized (fastBootHibernateReactivePersistenceProvider) {
                localDelegate = this.delegate;
                if (localDelegate == null) {
                    this.delegate = localDelegate = new FastBootHibernatePersistenceProvider(this.hibernateOrmRuntimeConfig, this.integrationRuntimeDescriptors);
                }
            }
        }
        return localDelegate;
    }
}

